/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.KtorExperimentalAPI;
import java.io.File;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\f\u0010\u0005\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0001H\u0007\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\u0001H\u0002\u00a8\u0006\b"}, d2={"combineSafe", "Ljava/io/File;", "dir", "relativePath", "", "dropLeadingTopDirs", "normalizeAndRelativize", "notRooted", "ktor-utils"})
public final class PathKt {
    @KtorExperimentalAPI
    @NotNull
    public static final File combineSafe(@NotNull File $this$combineSafe, @NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)$this$combineSafe, (String)"$this$combineSafe");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        return PathKt.combineSafe($this$combineSafe, new File(relativePath));
    }

    @KtorExperimentalAPI
    @NotNull
    public static final File normalizeAndRelativize(@NotNull File $this$normalizeAndRelativize) {
        Intrinsics.checkParameterIsNotNull((Object)$this$normalizeAndRelativize, (String)"$this$normalizeAndRelativize");
        return PathKt.dropLeadingTopDirs(PathKt.notRooted(FilesKt.normalize((File)$this$normalizeAndRelativize)));
    }

    private static final File combineSafe(File dir, File relativePath) {
        File normalized = PathKt.normalizeAndRelativize(relativePath);
        if (FilesKt.startsWith((File)normalized, (String)"..")) {
            throw (Throwable)new IllegalArgumentException("Bad relative path " + relativePath);
        }
        boolean bl = !normalized.isAbsolute();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Bad relative path " + relativePath;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return new File(dir, normalized.getPath());
    }

    /*
     * WARNING - void declaration
     */
    private static final File notRooted(@NotNull File $this$notRooted) {
        String string;
        String string2;
        block5: {
            if (!FilesKt.isRooted((File)$this$notRooted)) {
                return $this$notRooted;
            }
            File current = $this$notRooted;
            while (current.getParentFile() != null) {
                File parent;
                current = parent;
            }
            String string3 = $this$notRooted.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"path");
            String $this$dropWhile$iv = StringsKt.drop((String)string3, (int)current.getName().length());
            boolean $i$f$dropWhile = false;
            int n = 0;
            int n2 = ((CharSequence)$this$dropWhile$iv).length();
            while (n < n2) {
                void index$iv;
                char it = $this$dropWhile$iv.charAt((int)index$iv);
                boolean bl = false;
                if (!(it == '\\' || it == '/')) {
                    String string4 = $this$dropWhile$iv;
                    boolean bl2 = false;
                    String string5 = string4.substring((int)index$iv);
                    string2 = string5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                    break block5;
                }
                ++index$iv;
            }
            string2 = "";
        }
        String string6 = string = string2;
        return new File(string6);
    }

    private static final File dropLeadingTopDirs(@NotNull File $this$dropLeadingTopDirs) {
        String string;
        char c;
        int startIndex = 0;
        String string2 = $this$dropLeadingTopDirs.getPath();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        String path = string2;
        int lastIndex = path.length() - 1;
        while (startIndex < lastIndex && path.charAt(startIndex) == '.') {
            char second = path.charAt(startIndex + 1);
            if (second == '\\' || second == '/') {
                startIndex += 2;
                continue;
            }
            if (second != '.') break;
            if (startIndex + 2 == path.length()) {
                startIndex += 2;
                continue;
            }
            c = path.charAt(startIndex + 2);
            boolean bl = false;
            boolean bl2 = false;
            char it = c;
            boolean bl3 = false;
            if (!(it == '/' || it == '\\')) continue;
            startIndex += 3;
        }
        if (startIndex == 0) {
            return $this$dropLeadingTopDirs;
        }
        if (startIndex >= path.length()) {
            return new File(".");
        }
        String string3 = path;
        c = '\u0000';
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(startIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        String string6 = string = string5;
        return new File(string6);
    }
}

