/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.KtorExperimentalAPI;
import java.io.File;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\f\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0007H\u0007\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002\u001a\f\u0010\u000b\u001a\u00020\t*\u00020\nH\u0002\u001a\f\u0010\f\u001a\u00020\u0001*\u00020\u0001H\u0007\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u0001H\u0002\u00a8\u0006\u000e"}, d2={"combineSafe", "Ljava/io/File;", "dir", "relativePath", "dropLeadingTopDirs", "", "path", "", "isPathSeparator", "", "", "isPathSeparatorOrDot", "normalizeAndRelativize", "notRooted", "ktor-utils"})
public final class PathKt {
    @KtorExperimentalAPI
    @NotNull
    public static final File combineSafe(@NotNull File $this$combineSafe, @NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)$this$combineSafe, (String)"$this$combineSafe");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        return PathKt.combineSafe($this$combineSafe, new File(relativePath));
    }

    @KtorExperimentalAPI
    @NotNull
    public static final File normalizeAndRelativize(@NotNull File $this$normalizeAndRelativize) {
        Intrinsics.checkParameterIsNotNull((Object)$this$normalizeAndRelativize, (String)"$this$normalizeAndRelativize");
        return PathKt.dropLeadingTopDirs(PathKt.notRooted(FilesKt.normalize((File)$this$normalizeAndRelativize)));
    }

    private static final File combineSafe(File dir, File relativePath) {
        File normalized = PathKt.normalizeAndRelativize(relativePath);
        if (FilesKt.startsWith((File)normalized, (String)"..")) {
            throw (Throwable)new IllegalArgumentException("Bad relative path " + relativePath);
        }
        boolean bl = !normalized.isAbsolute();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Bad relative path " + relativePath;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return new File(dir, normalized.getPath());
    }

    /*
     * WARNING - void declaration
     */
    private static final File notRooted(@NotNull File $this$notRooted) {
        String string;
        String string2;
        block5: {
            if (!FilesKt.isRooted((File)$this$notRooted)) {
                return $this$notRooted;
            }
            File current = $this$notRooted;
            while (current.getParentFile() != null) {
                File parent;
                current = parent;
            }
            String string3 = $this$notRooted.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"path");
            String $this$dropWhile$iv = StringsKt.drop((String)string3, (int)current.getName().length());
            boolean $i$f$dropWhile = false;
            int n = 0;
            int n2 = ((CharSequence)$this$dropWhile$iv).length();
            while (n < n2) {
                void index$iv;
                char it = $this$dropWhile$iv.charAt((int)index$iv);
                boolean bl = false;
                if (!(it == '\\' || it == '/')) {
                    String string4 = $this$dropWhile$iv;
                    boolean bl2 = false;
                    String string5 = string4.substring((int)index$iv);
                    string2 = string5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                    break block5;
                }
                ++index$iv;
            }
            string2 = "";
        }
        String string6 = string = string2;
        return new File(string6);
    }

    public static final int dropLeadingTopDirs(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        int startIndex = 0;
        int lastIndex = path.length() - 1;
        while (startIndex <= lastIndex) {
            char first = path.charAt(startIndex);
            if (PathKt.isPathSeparator(first)) {
                ++startIndex;
                continue;
            }
            if (first != '.') break;
            if (startIndex == lastIndex) {
                ++startIndex;
                break;
            }
            char second = path.charAt(startIndex + 1);
            if (PathKt.isPathSeparator(second)) {
                startIndex += 2;
                continue;
            }
            if (second != '.') break;
            if (startIndex + 2 == path.length()) {
                startIndex += 2;
                continue;
            }
            if (!PathKt.isPathSeparator(path.charAt(startIndex + 2))) break;
            startIndex += 3;
        }
        return startIndex;
    }

    private static final boolean isPathSeparator(char $this$isPathSeparator) {
        return $this$isPathSeparator == '\\' || $this$isPathSeparator == '/';
    }

    private static final boolean isPathSeparatorOrDot(char $this$isPathSeparatorOrDot) {
        return $this$isPathSeparatorOrDot == '.' || PathKt.isPathSeparator($this$isPathSeparatorOrDot);
    }

    private static final File dropLeadingTopDirs(@NotNull File $this$dropLeadingTopDirs) {
        String string;
        String string2 = $this$dropLeadingTopDirs.getPath();
        if (string2 == null) {
            string2 = "";
        }
        int startIndex = PathKt.dropLeadingTopDirs(string2);
        if (startIndex == 0) {
            return $this$dropLeadingTopDirs;
        }
        if (startIndex >= $this$dropLeadingTopDirs.getPath().length()) {
            return new File(".");
        }
        String string3 = $this$dropLeadingTopDirs.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"path");
        String string4 = string3;
        boolean bl = false;
        String string5 = string4;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(startIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
        String string7 = string = string6;
        return new File(string7);
    }
}

