/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.collections.internal;

import io.ktor.util.InternalAPI;
import io.ktor.util.collections.internal.SharedList;
import io.ktor.utils.io.NativeUtilsJvmKt;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalAPI
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\n\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0010*\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\b\u0001\u0018\u0000*\u0004\b\u0000\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000#B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00018\u0000H\u0096\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\f\u001a\u00020\u00072\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u000f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0019\u0010\u0011\u001a\u00020\u00022\b\u0010\u0006\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0018\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0015H\u0096\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0019\u0010\u0018\u001a\u00020\u00022\b\u0010\u0006\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0012J\u0017\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00192\u0006\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001cJ\"\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u00022\b\u0010\u001d\u001a\u0004\u0018\u00018\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u001f\u0010 J'\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000#2\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b$\u0010%R\u001c\u0010\u0003\u001a\u00020\u00028\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010&\u001a\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lio/ktor/util/collections/internal/SharedList;", "T", "", "size", "<init>", "(I)V", "element", "", "contains", "(Ljava/lang/Object;)Z", "", "elements", "containsAll", "(Ljava/util/Collection;)Z", "index", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "()Z", "", "iterator", "()Ljava/util/Iterator;", "lastIndexOf", "", "listIterator", "()Ljava/util/ListIterator;", "(I)Ljava/util/ListIterator;", "value", "", "set", "(ILjava/lang/Object;)V", "fromIndex", "toIndex", "", "subList", "(II)Ljava/util/List;", "I", "getSize", "()I", "ktor-utils"})
public final class SharedList<T>
implements List<T>,
KMappedMarker {
    private final int size;
    @NotNull
    /* synthetic */ AtomicReferenceArray data;

    public SharedList(int size) {
        this.size = size;
        this.data = new AtomicReferenceArray(this.size());
        NativeUtilsJvmKt.makeShared((Object)this);
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public final void set(int index, @Nullable T value) {
        this.data.set(index, value);
    }

    @Override
    public boolean contains(@Nullable Object element) {
        int n = 0;
        int n2 = this.size();
        if (n < n2) {
            do {
                int index;
                if (!Intrinsics.areEqual(this.data.get(index = n++), (Object)element)) continue;
                return true;
            } while (n < n2);
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$all$iv = elements;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (this.contains(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public T get(int index) {
        return (T)this.data.get(index);
    }

    @Override
    public int indexOf(@Nullable Object element) {
        int n = 0;
        int n2 = this.size();
        if (n < n2) {
            do {
                int index;
                if (!Intrinsics.areEqual(this.data.get(index = n++), (Object)element)) continue;
                return index;
            } while (n < n2);
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.listIterator(0);
    }

    @Override
    public int lastIndexOf(@Nullable Object element) {
        return CollectionsKt.asReversed((List)this).indexOf(element);
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int index) {
        return new ListIterator<T>(index, this){
            @NotNull
            private volatile /* synthetic */ int currentIndex;
            private static final /* synthetic */ AtomicIntegerFieldUpdater currentIndex$FU;
            final /* synthetic */ int $index;
            final /* synthetic */ SharedList<T> this$0;
            {
                this.$index = $index;
                this.this$0 = $receiver;
                this.currentIndex = this.$index;
                NativeUtilsJvmKt.makeShared((Object)this);
            }

            public boolean hasNext() {
                return this.currentIndex < this.this$0.size();
            }

            public boolean hasPrevious() {
                return this.currentIndex > 0;
            }

            @Nullable
            public T next() {
                boolean bl = this.hasNext();
                boolean bl2 = false;
                boolean bl3 = false;
                bl3 = false;
                boolean bl4 = false;
                if (!bl) {
                    boolean bl5 = false;
                    String string = "Check failed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                int current = currentIndex$FU.getAndIncrement(this);
                return (T)this.this$0.data.get(current);
            }

            public int nextIndex() {
                boolean bl = this.hasNext();
                boolean bl2 = false;
                boolean bl3 = false;
                bl3 = false;
                boolean bl4 = false;
                if (!bl) {
                    boolean bl5 = false;
                    String string = "Check failed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                return this.currentIndex + 1;
            }

            @Nullable
            public T previous() {
                boolean bl = this.hasPrevious();
                boolean bl2 = false;
                boolean bl3 = false;
                bl3 = false;
                boolean bl4 = false;
                if (!bl) {
                    boolean bl5 = false;
                    String string = "Check failed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                int current = currentIndex$FU.getAndDecrement(this);
                return (T)this.this$0.data.get(current);
            }

            public int previousIndex() {
                boolean bl = this.hasPrevious();
                boolean bl2 = false;
                boolean bl3 = false;
                bl3 = false;
                boolean bl4 = false;
                if (!bl) {
                    boolean bl5 = false;
                    String string = "Check failed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                return this.currentIndex - 1;
            }

            public void add(T element) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            public void set(T element) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            static {
                currentIndex$FU = AtomicIntegerFieldUpdater.newUpdater(listIterator.1.class, "currentIndex");
            }
        };
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        SharedList result = new SharedList(toIndex - fromIndex);
        int n = fromIndex;
        if (n < toIndex) {
            do {
                int index = n++;
                result.set(index - fromIndex, (T)this.data.get(index));
            } while (n < toIndex);
        }
        return result;
    }

    @Override
    public boolean add(T element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends T> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(UnaryOperator<T> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void sort(Comparator<? super T> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

