package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1CSIDriverSpecBuilder extends V1CSIDriverSpecFluentImpl<V1CSIDriverSpecBuilder> implements VisitableBuilder<V1CSIDriverSpec,V1CSIDriverSpecBuilder>{

    V1CSIDriverSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1CSIDriverSpecBuilder(){
            this(true);
    }
    public V1CSIDriverSpecBuilder(Boolean validationEnabled){
            this(new V1CSIDriverSpec(), validationEnabled);
    }
    public V1CSIDriverSpecBuilder(V1CSIDriverSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1CSIDriverSpecBuilder(V1CSIDriverSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1CSIDriverSpec(), validationEnabled);
    }
    public V1CSIDriverSpecBuilder(V1CSIDriverSpecFluent<?> fluent,V1CSIDriverSpec instance){
            this(fluent, instance, true);
    }
    public V1CSIDriverSpecBuilder(V1CSIDriverSpecFluent<?> fluent,V1CSIDriverSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAttachRequired(instance.getAttachRequired());

            fluent.withPodInfoOnMount(instance.getPodInfoOnMount());

            fluent.withVolumeLifecycleModes(instance.getVolumeLifecycleModes());

            this.validationEnabled = validationEnabled; 
    }
    public V1CSIDriverSpecBuilder(V1CSIDriverSpec instance){
            this(instance,true);
    }
    public V1CSIDriverSpecBuilder(V1CSIDriverSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAttachRequired(instance.getAttachRequired());

            this.withPodInfoOnMount(instance.getPodInfoOnMount());

            this.withVolumeLifecycleModes(instance.getVolumeLifecycleModes());

            this.validationEnabled = validationEnabled; 
    }

    public V1CSIDriverSpec build(){
            V1CSIDriverSpec buildable = new V1CSIDriverSpec();
            buildable.setAttachRequired(fluent.isAttachRequired());
            buildable.setPodInfoOnMount(fluent.isPodInfoOnMount());
            buildable.setVolumeLifecycleModes(fluent.getVolumeLifecycleModes());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1CSIDriverSpecBuilder that = (V1CSIDriverSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
