package io.kubernetes.client.openapi.models;

import java.lang.Integer;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import org.joda.time.DateTime;

public class V1HorizontalPodAutoscalerStatusFluentImpl<A extends V1HorizontalPodAutoscalerStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1HorizontalPodAutoscalerStatusFluent<A>{

    private Integer currentCPUUtilizationPercentage;
    private Integer currentReplicas;
    private Integer desiredReplicas;
    private DateTime lastScaleTime;
    private Long observedGeneration;

    public V1HorizontalPodAutoscalerStatusFluentImpl(){
    }
    public V1HorizontalPodAutoscalerStatusFluentImpl(V1HorizontalPodAutoscalerStatus instance){
            this.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage());

            this.withCurrentReplicas(instance.getCurrentReplicas());

            this.withDesiredReplicas(instance.getDesiredReplicas());

            this.withLastScaleTime(instance.getLastScaleTime());

            this.withObservedGeneration(instance.getObservedGeneration());

    }

    public Integer getCurrentCPUUtilizationPercentage(){
            return this.currentCPUUtilizationPercentage;
    }

    public A withCurrentCPUUtilizationPercentage(Integer currentCPUUtilizationPercentage){
            this.currentCPUUtilizationPercentage=currentCPUUtilizationPercentage; return (A) this;
    }

    public Boolean hasCurrentCPUUtilizationPercentage(){
            return this.currentCPUUtilizationPercentage != null;
    }

    public Integer getCurrentReplicas(){
            return this.currentReplicas;
    }

    public A withCurrentReplicas(Integer currentReplicas){
            this.currentReplicas=currentReplicas; return (A) this;
    }

    public Boolean hasCurrentReplicas(){
            return this.currentReplicas != null;
    }

    public Integer getDesiredReplicas(){
            return this.desiredReplicas;
    }

    public A withDesiredReplicas(Integer desiredReplicas){
            this.desiredReplicas=desiredReplicas; return (A) this;
    }

    public Boolean hasDesiredReplicas(){
            return this.desiredReplicas != null;
    }

    public DateTime getLastScaleTime(){
            return this.lastScaleTime;
    }

    public A withLastScaleTime(DateTime lastScaleTime){
            this.lastScaleTime=lastScaleTime; return (A) this;
    }

    public Boolean hasLastScaleTime(){
            return this.lastScaleTime != null;
    }

    public A withNewLastScaleTime(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withLastScaleTime(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewLastScaleTime(Object arg0){
            return (A)withLastScaleTime(new DateTime(arg0));
    }

    public A withNewLastScaleTime(long arg0){
            return (A)withLastScaleTime(new DateTime(arg0));
    }

    public Long getObservedGeneration(){
            return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration){
            this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration(){
            return this.observedGeneration != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1HorizontalPodAutoscalerStatusFluentImpl that = (V1HorizontalPodAutoscalerStatusFluentImpl) o;
            if (currentCPUUtilizationPercentage != null ? !currentCPUUtilizationPercentage.equals(that.currentCPUUtilizationPercentage) :that.currentCPUUtilizationPercentage != null) return false;
            if (currentReplicas != null ? !currentReplicas.equals(that.currentReplicas) :that.currentReplicas != null) return false;
            if (desiredReplicas != null ? !desiredReplicas.equals(that.desiredReplicas) :that.desiredReplicas != null) return false;
            if (lastScaleTime != null ? !lastScaleTime.equals(that.lastScaleTime) :that.lastScaleTime != null) return false;
            if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
            return true;
    }




}
