package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

public class AppsV1beta1DeploymentFluentImpl<A extends AppsV1beta1DeploymentFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements AppsV1beta1DeploymentFluent<A>{

    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private AppsV1beta1DeploymentSpecBuilder spec;
    private AppsV1beta1DeploymentStatusBuilder status;

    public AppsV1beta1DeploymentFluentImpl(){
    }
    public AppsV1beta1DeploymentFluentImpl(AppsV1beta1Deployment instance){
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public AppsV1beta1DeploymentFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public AppsV1beta1DeploymentFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public AppsV1beta1DeploymentFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public AppsV1beta1DeploymentFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public AppsV1beta1DeploymentFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public AppsV1beta1DeploymentSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public AppsV1beta1DeploymentSpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(AppsV1beta1DeploymentSpec spec){
            _visitables.remove(this.spec);
            if (spec!=null){ this.spec= new AppsV1beta1DeploymentSpecBuilder(spec); _visitables.add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public AppsV1beta1DeploymentFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public AppsV1beta1DeploymentFluent.SpecNested<A> withNewSpecLike(AppsV1beta1DeploymentSpec item){
            return new SpecNestedImpl(item);
    }

    public AppsV1beta1DeploymentFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public AppsV1beta1DeploymentFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new AppsV1beta1DeploymentSpecBuilder().build());
    }

    public AppsV1beta1DeploymentFluent.SpecNested<A> editOrNewSpecLike(AppsV1beta1DeploymentSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public AppsV1beta1DeploymentStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public AppsV1beta1DeploymentStatus buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(AppsV1beta1DeploymentStatus status){
            _visitables.remove(this.status);
            if (status!=null){ this.status= new AppsV1beta1DeploymentStatusBuilder(status); _visitables.add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public AppsV1beta1DeploymentFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public AppsV1beta1DeploymentFluent.StatusNested<A> withNewStatusLike(AppsV1beta1DeploymentStatus item){
            return new StatusNestedImpl(item);
    }

    public AppsV1beta1DeploymentFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public AppsV1beta1DeploymentFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new AppsV1beta1DeploymentStatusBuilder().build());
    }

    public AppsV1beta1DeploymentFluent.StatusNested<A> editOrNewStatusLike(AppsV1beta1DeploymentStatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AppsV1beta1DeploymentFluentImpl that = (AppsV1beta1DeploymentFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<AppsV1beta1DeploymentFluent.MetadataNested<N>> implements AppsV1beta1DeploymentFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectMetaBuilder builder;
    
            MetadataNestedImpl(V1ObjectMeta item){
                    this.builder = new V1ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) AppsV1beta1DeploymentFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends AppsV1beta1DeploymentSpecFluentImpl<AppsV1beta1DeploymentFluent.SpecNested<N>> implements AppsV1beta1DeploymentFluent.SpecNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final AppsV1beta1DeploymentSpecBuilder builder;
    
            SpecNestedImpl(AppsV1beta1DeploymentSpec item){
                    this.builder = new AppsV1beta1DeploymentSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new AppsV1beta1DeploymentSpecBuilder(this);
            }
    
    public N and(){
            return (N) AppsV1beta1DeploymentFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends AppsV1beta1DeploymentStatusFluentImpl<AppsV1beta1DeploymentFluent.StatusNested<N>> implements AppsV1beta1DeploymentFluent.StatusNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final AppsV1beta1DeploymentStatusBuilder builder;
    
            StatusNestedImpl(AppsV1beta1DeploymentStatus item){
                    this.builder = new AppsV1beta1DeploymentStatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new AppsV1beta1DeploymentStatusBuilder(this);
            }
    
    public N and(){
            return (N) AppsV1beta1DeploymentFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
