package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface ExtensionsV1beta1DeploymentFluent<A extends ExtensionsV1beta1DeploymentFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata();
    public V1ObjectMeta buildMetadata();
    public A withMetadata(V1ObjectMeta metadata);
    public Boolean hasMetadata();
    public ExtensionsV1beta1DeploymentFluent.MetadataNested<A> withNewMetadata();
    public ExtensionsV1beta1DeploymentFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item);
    public ExtensionsV1beta1DeploymentFluent.MetadataNested<A> editMetadata();
    public ExtensionsV1beta1DeploymentFluent.MetadataNested<A> editOrNewMetadata();
    public ExtensionsV1beta1DeploymentFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1DeploymentSpec getSpec();
    public ExtensionsV1beta1DeploymentSpec buildSpec();
    public A withSpec(ExtensionsV1beta1DeploymentSpec spec);
    public Boolean hasSpec();
    public ExtensionsV1beta1DeploymentFluent.SpecNested<A> withNewSpec();
    public ExtensionsV1beta1DeploymentFluent.SpecNested<A> withNewSpecLike(ExtensionsV1beta1DeploymentSpec item);
    public ExtensionsV1beta1DeploymentFluent.SpecNested<A> editSpec();
    public ExtensionsV1beta1DeploymentFluent.SpecNested<A> editOrNewSpec();
    public ExtensionsV1beta1DeploymentFluent.SpecNested<A> editOrNewSpecLike(ExtensionsV1beta1DeploymentSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1DeploymentStatus getStatus();
    public ExtensionsV1beta1DeploymentStatus buildStatus();
    public A withStatus(ExtensionsV1beta1DeploymentStatus status);
    public Boolean hasStatus();
    public ExtensionsV1beta1DeploymentFluent.StatusNested<A> withNewStatus();
    public ExtensionsV1beta1DeploymentFluent.StatusNested<A> withNewStatusLike(ExtensionsV1beta1DeploymentStatus item);
    public ExtensionsV1beta1DeploymentFluent.StatusNested<A> editStatus();
    public ExtensionsV1beta1DeploymentFluent.StatusNested<A> editOrNewStatus();
    public ExtensionsV1beta1DeploymentFluent.StatusNested<A> editOrNewStatusLike(ExtensionsV1beta1DeploymentStatus item);

    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectMetaFluent<ExtensionsV1beta1DeploymentFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.kubernetes.client.fluent.Nested<N>,ExtensionsV1beta1DeploymentSpecFluent<ExtensionsV1beta1DeploymentFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.kubernetes.client.fluent.Nested<N>,ExtensionsV1beta1DeploymentStatusFluent<ExtensionsV1beta1DeploymentFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
