package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExtensionsV1beta1FSGroupStrategyOptionsBuilder extends ExtensionsV1beta1FSGroupStrategyOptionsFluentImpl<ExtensionsV1beta1FSGroupStrategyOptionsBuilder> implements VisitableBuilder<ExtensionsV1beta1FSGroupStrategyOptions,ExtensionsV1beta1FSGroupStrategyOptionsBuilder>{

    ExtensionsV1beta1FSGroupStrategyOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public ExtensionsV1beta1FSGroupStrategyOptionsBuilder(){
            this(true);
    }
    public ExtensionsV1beta1FSGroupStrategyOptionsBuilder(Boolean validationEnabled){
            this(new ExtensionsV1beta1FSGroupStrategyOptions(), validationEnabled);
    }
    public ExtensionsV1beta1FSGroupStrategyOptionsBuilder(ExtensionsV1beta1FSGroupStrategyOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public ExtensionsV1beta1FSGroupStrategyOptionsBuilder(ExtensionsV1beta1FSGroupStrategyOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExtensionsV1beta1FSGroupStrategyOptions(), validationEnabled);
    }
    public ExtensionsV1beta1FSGroupStrategyOptionsBuilder(ExtensionsV1beta1FSGroupStrategyOptionsFluent<?> fluent,ExtensionsV1beta1FSGroupStrategyOptions instance){
            this(fluent, instance, true);
    }
    public ExtensionsV1beta1FSGroupStrategyOptionsBuilder(ExtensionsV1beta1FSGroupStrategyOptionsFluent<?> fluent,ExtensionsV1beta1FSGroupStrategyOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRanges(instance.getRanges());

            fluent.withRule(instance.getRule());

            this.validationEnabled = validationEnabled; 
    }
    public ExtensionsV1beta1FSGroupStrategyOptionsBuilder(ExtensionsV1beta1FSGroupStrategyOptions instance){
            this(instance,true);
    }
    public ExtensionsV1beta1FSGroupStrategyOptionsBuilder(ExtensionsV1beta1FSGroupStrategyOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRanges(instance.getRanges());

            this.withRule(instance.getRule());

            this.validationEnabled = validationEnabled; 
    }

    public ExtensionsV1beta1FSGroupStrategyOptions build(){
            ExtensionsV1beta1FSGroupStrategyOptions buildable = new ExtensionsV1beta1FSGroupStrategyOptions();
            buildable.setRanges(fluent.getRanges());
            buildable.setRule(fluent.getRule());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1FSGroupStrategyOptionsBuilder that = (ExtensionsV1beta1FSGroupStrategyOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
