package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import io.kubernetes.client.fluent.Predicate;

public interface V1APIResourceFluent<A extends V1APIResourceFluent<A>> extends Fluent<A>{


    public A addToCategories(int index,String item);
    public A setToCategories(int index,String item);
    public A addToCategories(String... items);
    public A addAllToCategories(Collection<String> items);
    public A removeFromCategories(String... items);
    public A removeAllFromCategories(Collection<String> items);
    public List<String> getCategories();
    public String getCategory(int index);
    public String getFirstCategory();
    public String getLastCategory();
    public String getMatchingCategory(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withCategories(List<String> categories);
    public A withCategories(String... categories);
    public Boolean hasCategories();
    public String getGroup();
    public A withGroup(String group);
    public Boolean hasGroup();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public Boolean isNamespaced();
    public A withNamespaced(Boolean namespaced);
    public Boolean hasNamespaced();
    public A withNewNamespaced(boolean arg1);
    public A withNewNamespaced(String arg1);
    public A addToShortNames(int index,String item);
    public A setToShortNames(int index,String item);
    public A addToShortNames(String... items);
    public A addAllToShortNames(Collection<String> items);
    public A removeFromShortNames(String... items);
    public A removeAllFromShortNames(Collection<String> items);
    public List<String> getShortNames();
    public String getShortName(int index);
    public String getFirstShortName();
    public String getLastShortName();
    public String getMatchingShortName(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withShortNames(List<String> shortNames);
    public A withShortNames(String... shortNames);
    public Boolean hasShortNames();
    public String getSingularName();
    public A withSingularName(String singularName);
    public Boolean hasSingularName();
    public A addToVerbs(int index,String item);
    public A setToVerbs(int index,String item);
    public A addToVerbs(String... items);
    public A addAllToVerbs(Collection<String> items);
    public A removeFromVerbs(String... items);
    public A removeAllFromVerbs(Collection<String> items);
    public List<String> getVerbs();
    public String getVerb(int index);
    public String getFirstVerb();
    public String getLastVerb();
    public String getMatchingVerb(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withVerbs(List<String> verbs);
    public A withVerbs(String... verbs);
    public Boolean hasVerbs();
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();



}
