package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1CephFSVolumeSourceFluent<A extends V1CephFSVolumeSourceFluent<A>> extends Fluent<A>{


    public A addToMonitors(int index,String item);
    public A setToMonitors(int index,String item);
    public A addToMonitors(String... items);
    public A addAllToMonitors(Collection<String> items);
    public A removeFromMonitors(String... items);
    public A removeAllFromMonitors(Collection<String> items);
    public List<String> getMonitors();
    public String getMonitor(int index);
    public String getFirstMonitor();
    public String getLastMonitor();
    public String getMatchingMonitor(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withMonitors(List<String> monitors);
    public A withMonitors(String... monitors);
    public Boolean hasMonitors();
    public String getPath();
    public A withPath(String path);
    public Boolean hasPath();
    public Boolean isReadOnly();
    public A withReadOnly(Boolean readOnly);
    public Boolean hasReadOnly();
    public A withNewReadOnly(boolean arg1);
    public A withNewReadOnly(String arg1);
    public String getSecretFile();
    public A withSecretFile(String secretFile);
    public Boolean hasSecretFile();
    
/**
 * This method has been deprecated, please use method buildSecretRef instead.
 * @return The buildable object.
 */
@Deprecated public V1LocalObjectReference getSecretRef();
    public V1LocalObjectReference buildSecretRef();
    public A withSecretRef(V1LocalObjectReference secretRef);
    public Boolean hasSecretRef();
    public V1CephFSVolumeSourceFluent.SecretRefNested<A> withNewSecretRef();
    public V1CephFSVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(V1LocalObjectReference item);
    public V1CephFSVolumeSourceFluent.SecretRefNested<A> editSecretRef();
    public V1CephFSVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef();
    public V1CephFSVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(V1LocalObjectReference item);
    public String getUser();
    public A withUser(String user);
    public Boolean hasUser();

    public interface SecretRefNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1LocalObjectReferenceFluent<V1CephFSVolumeSourceFluent.SecretRefNested<N>>{

        
    public N and();    public N endSecretRef();
}


}
