package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1ConfigMapVolumeSourceFluent<A extends V1ConfigMapVolumeSourceFluent<A>> extends Fluent<A>{


    public Integer getDefaultMode();
    public A withDefaultMode(Integer defaultMode);
    public Boolean hasDefaultMode();
    public A withNewDefaultMode(int arg1);
    public A withNewDefaultMode(String arg1);
    public A addToItems(int index,V1KeyToPath item);
    public A setToItems(int index,V1KeyToPath item);
    public A addToItems(V1KeyToPath... items);
    public A addAllToItems(Collection<V1KeyToPath> items);
    public A removeFromItems(V1KeyToPath... items);
    public A removeAllFromItems(Collection<V1KeyToPath> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<V1KeyToPath> getItems();
    public List<V1KeyToPath> buildItems();
    public V1KeyToPath buildItem(int index);
    public V1KeyToPath buildFirstItem();
    public V1KeyToPath buildLastItem();
    public V1KeyToPath buildMatchingItem(io.kubernetes.client.fluent.Predicate<V1KeyToPathBuilder> predicate);
    public A withItems(List<V1KeyToPath> items);
    public A withItems(V1KeyToPath... items);
    public Boolean hasItems();
    public V1ConfigMapVolumeSourceFluent.ItemsNested<A> addNewItem();
    public V1ConfigMapVolumeSourceFluent.ItemsNested<A> addNewItemLike(V1KeyToPath item);
    public V1ConfigMapVolumeSourceFluent.ItemsNested<A> setNewItemLike(int index,V1KeyToPath item);
    public V1ConfigMapVolumeSourceFluent.ItemsNested<A> editItem(int index);
    public V1ConfigMapVolumeSourceFluent.ItemsNested<A> editFirstItem();
    public V1ConfigMapVolumeSourceFluent.ItemsNested<A> editLastItem();
    public V1ConfigMapVolumeSourceFluent.ItemsNested<A> editMatchingItem(io.kubernetes.client.fluent.Predicate<V1KeyToPathBuilder> predicate);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public Boolean isOptional();
    public A withOptional(Boolean optional);
    public Boolean hasOptional();
    public A withNewOptional(boolean arg1);
    public A withNewOptional(String arg1);

    public interface ItemsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1KeyToPathFluent<V1ConfigMapVolumeSourceFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
