package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1ConfigMapVolumeSourceFluentImpl<A extends V1ConfigMapVolumeSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1ConfigMapVolumeSourceFluent<A>{

    private Integer defaultMode;
    private List<V1KeyToPathBuilder> items;
    private String name;
    private Boolean optional;

    public V1ConfigMapVolumeSourceFluentImpl(){
    }
    public V1ConfigMapVolumeSourceFluentImpl(V1ConfigMapVolumeSource instance){
            this.withDefaultMode(instance.getDefaultMode());

            this.withItems(instance.getItems());

            this.withName(instance.getName());

            this.withOptional(instance.isOptional());

    }

    public Integer getDefaultMode(){
            return this.defaultMode;
    }

    public A withDefaultMode(Integer defaultMode){
            this.defaultMode=defaultMode; return (A) this;
    }

    public Boolean hasDefaultMode(){
            return this.defaultMode != null;
    }

    public A withNewDefaultMode(int arg1){
            return (A)withDefaultMode(new Integer(arg1));
    }

    public A withNewDefaultMode(String arg1){
            return (A)withDefaultMode(new Integer(arg1));
    }

    public A addToItems(int index,V1KeyToPath item){
            if (this.items == null) {this.items = new ArrayList<V1KeyToPathBuilder>();}
            V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,V1KeyToPath item){
            if (this.items == null) {this.items = new ArrayList<V1KeyToPathBuilder>();}
            V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToItems(V1KeyToPath... items){
            if (this.items == null) {this.items = new ArrayList<V1KeyToPathBuilder>();}
            for (V1KeyToPath item : items) {V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<V1KeyToPath> items){
            if (this.items == null) {this.items = new ArrayList<V1KeyToPathBuilder>();}
            for (V1KeyToPath item : items) {V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(V1KeyToPath... items){
            for (V1KeyToPath item : items) {V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);_visitables.remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<V1KeyToPath> items){
            for (V1KeyToPath item : items) {V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);_visitables.remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<V1KeyToPath> getItems(){
            return build(items);
    }

    public List<V1KeyToPath> buildItems(){
            return build(items);
    }

    public V1KeyToPath buildItem(int index){
            return this.items.get(index).build();
    }

    public V1KeyToPath buildFirstItem(){
            return this.items.get(0).build();
    }

    public V1KeyToPath buildLastItem(){
            return this.items.get(items.size() - 1).build();
    }

    public V1KeyToPath buildMatchingItem(io.kubernetes.client.fluent.Predicate<V1KeyToPathBuilder> predicate){
            for (V1KeyToPathBuilder item: items) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withItems(List<V1KeyToPath> items){
            if (this.items != null) { _visitables.removeAll(this.items);}
            if (items != null) {this.items = new ArrayList<V1KeyToPathBuilder>(); for (V1KeyToPath item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(V1KeyToPath... items){
            if (this.items != null) {this.items.clear();}
            if (items != null) {for (V1KeyToPath item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items != null && !items.isEmpty();
    }

    public V1ConfigMapVolumeSourceFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public V1ConfigMapVolumeSourceFluent.ItemsNested<A> addNewItemLike(V1KeyToPath item){
            return new ItemsNestedImpl(-1, item);
    }

    public V1ConfigMapVolumeSourceFluent.ItemsNested<A> setNewItemLike(int index,V1KeyToPath item){
            return new ItemsNestedImpl(index, item);
    }

    public V1ConfigMapVolumeSourceFluent.ItemsNested<A> editItem(int index){
            if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
            return setNewItemLike(index, buildItem(index));
    }

    public V1ConfigMapVolumeSourceFluent.ItemsNested<A> editFirstItem(){
            if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
            return setNewItemLike(0, buildItem(0));
    }

    public V1ConfigMapVolumeSourceFluent.ItemsNested<A> editLastItem(){
            int index = items.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
            return setNewItemLike(index, buildItem(index));
    }

    public V1ConfigMapVolumeSourceFluent.ItemsNested<A> editMatchingItem(io.kubernetes.client.fluent.Predicate<V1KeyToPathBuilder> predicate){
            int index = -1;
            for (int i=0;i<items.size();i++) { 
            if (predicate.apply(items.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
            return setNewItemLike(index, buildItem(index));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public Boolean isOptional(){
            return this.optional;
    }

    public A withOptional(Boolean optional){
            this.optional=optional; return (A) this;
    }

    public Boolean hasOptional(){
            return this.optional != null;
    }

    public A withNewOptional(boolean arg1){
            return (A)withOptional(new Boolean(arg1));
    }

    public A withNewOptional(String arg1){
            return (A)withOptional(new Boolean(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ConfigMapVolumeSourceFluentImpl that = (V1ConfigMapVolumeSourceFluentImpl) o;
            if (defaultMode != null ? !defaultMode.equals(that.defaultMode) :that.defaultMode != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (optional != null ? !optional.equals(that.optional) :that.optional != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends V1KeyToPathFluentImpl<V1ConfigMapVolumeSourceFluent.ItemsNested<N>> implements V1ConfigMapVolumeSourceFluent.ItemsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1KeyToPathBuilder builder;
        private final int index;
    
            ItemsNestedImpl(int index,V1KeyToPath item){
                    this.index = index;
                    this.builder = new V1KeyToPathBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1KeyToPathBuilder(this);
            }
    
    public N and(){
            return (N) V1ConfigMapVolumeSourceFluentImpl.this.setToItems(index, builder.build());
    }
    public N endItem(){
            return and();
    }

}


}
