package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import java.lang.Long;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import io.kubernetes.client.fluent.Predicate;

public interface V1ContainerImageFluent<A extends V1ContainerImageFluent<A>> extends Fluent<A>{


    public A addToNames(int index,String item);
    public A setToNames(int index,String item);
    public A addToNames(String... items);
    public A addAllToNames(Collection<String> items);
    public A removeFromNames(String... items);
    public A removeAllFromNames(Collection<String> items);
    public List<String> getNames();
    public String getName(int index);
    public String getFirstName();
    public String getLastName();
    public String getMatchingName(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withNames(List<String> names);
    public A withNames(String... names);
    public Boolean hasNames();
    public Long getSizeBytes();
    public A withSizeBytes(Long sizeBytes);
    public Boolean hasSizeBytes();
    public A withNewSizeBytes(String arg1);
    public A withNewSizeBytes(long arg1);



}
