package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1GitRepoVolumeSourceBuilder extends V1GitRepoVolumeSourceFluentImpl<V1GitRepoVolumeSourceBuilder> implements VisitableBuilder<V1GitRepoVolumeSource,V1GitRepoVolumeSourceBuilder>{

    V1GitRepoVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1GitRepoVolumeSourceBuilder(){
            this(true);
    }
    public V1GitRepoVolumeSourceBuilder(Boolean validationEnabled){
            this(new V1GitRepoVolumeSource(), validationEnabled);
    }
    public V1GitRepoVolumeSourceBuilder(V1GitRepoVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public V1GitRepoVolumeSourceBuilder(V1GitRepoVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1GitRepoVolumeSource(), validationEnabled);
    }
    public V1GitRepoVolumeSourceBuilder(V1GitRepoVolumeSourceFluent<?> fluent,V1GitRepoVolumeSource instance){
            this(fluent, instance, true);
    }
    public V1GitRepoVolumeSourceBuilder(V1GitRepoVolumeSourceFluent<?> fluent,V1GitRepoVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDirectory(instance.getDirectory());

            fluent.withRepository(instance.getRepository());

            fluent.withRevision(instance.getRevision());

            this.validationEnabled = validationEnabled; 
    }
    public V1GitRepoVolumeSourceBuilder(V1GitRepoVolumeSource instance){
            this(instance,true);
    }
    public V1GitRepoVolumeSourceBuilder(V1GitRepoVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDirectory(instance.getDirectory());

            this.withRepository(instance.getRepository());

            this.withRevision(instance.getRevision());

            this.validationEnabled = validationEnabled; 
    }

    public V1GitRepoVolumeSource build(){
            V1GitRepoVolumeSource buildable = new V1GitRepoVolumeSource();
            buildable.setDirectory(fluent.getDirectory());
            buildable.setRepository(fluent.getRepository());
            buildable.setRevision(fluent.getRevision());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1GitRepoVolumeSourceBuilder that = (V1GitRepoVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
