package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.util.LinkedHashMap;
import java.util.List;
import java.lang.Boolean;
import io.kubernetes.client.fluent.Fluent;
import java.lang.Long;
import java.util.Collection;
import java.util.Map;
import io.kubernetes.client.fluent.Nested;
import java.lang.Deprecated;
import java.lang.Integer;

public interface V1PodSpecFluent<A extends V1PodSpecFluent<A>> extends Fluent<A>{


    public Long getActiveDeadlineSeconds();
    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds);
    public Boolean hasActiveDeadlineSeconds();
    public A withNewActiveDeadlineSeconds(String arg1);
    public A withNewActiveDeadlineSeconds(long arg1);
    
/**
 * This method has been deprecated, please use method buildAffinity instead.
 * @return The buildable object.
 */
@Deprecated public V1Affinity getAffinity();
    public V1Affinity buildAffinity();
    public A withAffinity(V1Affinity affinity);
    public Boolean hasAffinity();
    public V1PodSpecFluent.AffinityNested<A> withNewAffinity();
    public V1PodSpecFluent.AffinityNested<A> withNewAffinityLike(V1Affinity item);
    public V1PodSpecFluent.AffinityNested<A> editAffinity();
    public V1PodSpecFluent.AffinityNested<A> editOrNewAffinity();
    public V1PodSpecFluent.AffinityNested<A> editOrNewAffinityLike(V1Affinity item);
    public Boolean isAutomountServiceAccountToken();
    public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken);
    public Boolean hasAutomountServiceAccountToken();
    public A withNewAutomountServiceAccountToken(boolean arg1);
    public A withNewAutomountServiceAccountToken(String arg1);
    public A addToContainers(int index,V1Container item);
    public A setToContainers(int index,V1Container item);
    public A addToContainers(V1Container... items);
    public A addAllToContainers(Collection<V1Container> items);
    public A removeFromContainers(V1Container... items);
    public A removeAllFromContainers(Collection<V1Container> items);
    
/**
 * This method has been deprecated, please use method buildContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<V1Container> getContainers();
    public List<V1Container> buildContainers();
    public V1Container buildContainer(int index);
    public V1Container buildFirstContainer();
    public V1Container buildLastContainer();
    public V1Container buildMatchingContainer(io.kubernetes.client.fluent.Predicate<V1ContainerBuilder> predicate);
    public A withContainers(List<V1Container> containers);
    public A withContainers(V1Container... containers);
    public Boolean hasContainers();
    public V1PodSpecFluent.ContainersNested<A> addNewContainer();
    public V1PodSpecFluent.ContainersNested<A> addNewContainerLike(V1Container item);
    public V1PodSpecFluent.ContainersNested<A> setNewContainerLike(int index,V1Container item);
    public V1PodSpecFluent.ContainersNested<A> editContainer(int index);
    public V1PodSpecFluent.ContainersNested<A> editFirstContainer();
    public V1PodSpecFluent.ContainersNested<A> editLastContainer();
    public V1PodSpecFluent.ContainersNested<A> editMatchingContainer(io.kubernetes.client.fluent.Predicate<V1ContainerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildDnsConfig instead.
 * @return The buildable object.
 */
@Deprecated public V1PodDNSConfig getDnsConfig();
    public V1PodDNSConfig buildDnsConfig();
    public A withDnsConfig(V1PodDNSConfig dnsConfig);
    public Boolean hasDnsConfig();
    public V1PodSpecFluent.DnsConfigNested<A> withNewDnsConfig();
    public V1PodSpecFluent.DnsConfigNested<A> withNewDnsConfigLike(V1PodDNSConfig item);
    public V1PodSpecFluent.DnsConfigNested<A> editDnsConfig();
    public V1PodSpecFluent.DnsConfigNested<A> editOrNewDnsConfig();
    public V1PodSpecFluent.DnsConfigNested<A> editOrNewDnsConfigLike(V1PodDNSConfig item);
    public String getDnsPolicy();
    public A withDnsPolicy(String dnsPolicy);
    public Boolean hasDnsPolicy();
    public A addToHostAliases(int index,V1HostAlias item);
    public A setToHostAliases(int index,V1HostAlias item);
    public A addToHostAliases(V1HostAlias... items);
    public A addAllToHostAliases(Collection<V1HostAlias> items);
    public A removeFromHostAliases(V1HostAlias... items);
    public A removeAllFromHostAliases(Collection<V1HostAlias> items);
    
/**
 * This method has been deprecated, please use method buildHostAliases instead.
 * @return The buildable object.
 */
@Deprecated public List<V1HostAlias> getHostAliases();
    public List<V1HostAlias> buildHostAliases();
    public V1HostAlias buildHostAlias(int index);
    public V1HostAlias buildFirstHostAlias();
    public V1HostAlias buildLastHostAlias();
    public V1HostAlias buildMatchingHostAlias(io.kubernetes.client.fluent.Predicate<V1HostAliasBuilder> predicate);
    public A withHostAliases(List<V1HostAlias> hostAliases);
    public A withHostAliases(V1HostAlias... hostAliases);
    public Boolean hasHostAliases();
    public V1PodSpecFluent.HostAliasesNested<A> addNewHostAlias();
    public V1PodSpecFluent.HostAliasesNested<A> addNewHostAliasLike(V1HostAlias item);
    public V1PodSpecFluent.HostAliasesNested<A> setNewHostAliasLike(int index,V1HostAlias item);
    public V1PodSpecFluent.HostAliasesNested<A> editHostAlias(int index);
    public V1PodSpecFluent.HostAliasesNested<A> editFirstHostAlias();
    public V1PodSpecFluent.HostAliasesNested<A> editLastHostAlias();
    public V1PodSpecFluent.HostAliasesNested<A> editMatchingHostAlias(io.kubernetes.client.fluent.Predicate<V1HostAliasBuilder> predicate);
    public Boolean isHostIPC();
    public A withHostIPC(Boolean hostIPC);
    public Boolean hasHostIPC();
    public A withNewHostIPC(boolean arg1);
    public A withNewHostIPC(String arg1);
    public Boolean isHostNetwork();
    public A withHostNetwork(Boolean hostNetwork);
    public Boolean hasHostNetwork();
    public A withNewHostNetwork(boolean arg1);
    public A withNewHostNetwork(String arg1);
    public Boolean isHostPID();
    public A withHostPID(Boolean hostPID);
    public Boolean hasHostPID();
    public A withNewHostPID(boolean arg1);
    public A withNewHostPID(String arg1);
    public String getHostname();
    public A withHostname(String hostname);
    public Boolean hasHostname();
    public A addToImagePullSecrets(int index,V1LocalObjectReference item);
    public A setToImagePullSecrets(int index,V1LocalObjectReference item);
    public A addToImagePullSecrets(V1LocalObjectReference... items);
    public A addAllToImagePullSecrets(Collection<V1LocalObjectReference> items);
    public A removeFromImagePullSecrets(V1LocalObjectReference... items);
    public A removeAllFromImagePullSecrets(Collection<V1LocalObjectReference> items);
    
/**
 * This method has been deprecated, please use method buildImagePullSecrets instead.
 * @return The buildable object.
 */
@Deprecated public List<V1LocalObjectReference> getImagePullSecrets();
    public List<V1LocalObjectReference> buildImagePullSecrets();
    public V1LocalObjectReference buildImagePullSecret(int index);
    public V1LocalObjectReference buildFirstImagePullSecret();
    public V1LocalObjectReference buildLastImagePullSecret();
    public V1LocalObjectReference buildMatchingImagePullSecret(io.kubernetes.client.fluent.Predicate<V1LocalObjectReferenceBuilder> predicate);
    public A withImagePullSecrets(List<V1LocalObjectReference> imagePullSecrets);
    public A withImagePullSecrets(V1LocalObjectReference... imagePullSecrets);
    public Boolean hasImagePullSecrets();
    public V1PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret();
    public V1PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(V1LocalObjectReference item);
    public V1PodSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index,V1LocalObjectReference item);
    public V1PodSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(int index);
    public V1PodSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret();
    public V1PodSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret();
    public V1PodSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(io.kubernetes.client.fluent.Predicate<V1LocalObjectReferenceBuilder> predicate);
    public A addToInitContainers(int index,V1Container item);
    public A setToInitContainers(int index,V1Container item);
    public A addToInitContainers(V1Container... items);
    public A addAllToInitContainers(Collection<V1Container> items);
    public A removeFromInitContainers(V1Container... items);
    public A removeAllFromInitContainers(Collection<V1Container> items);
    
/**
 * This method has been deprecated, please use method buildInitContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<V1Container> getInitContainers();
    public List<V1Container> buildInitContainers();
    public V1Container buildInitContainer(int index);
    public V1Container buildFirstInitContainer();
    public V1Container buildLastInitContainer();
    public V1Container buildMatchingInitContainer(io.kubernetes.client.fluent.Predicate<V1ContainerBuilder> predicate);
    public A withInitContainers(List<V1Container> initContainers);
    public A withInitContainers(V1Container... initContainers);
    public Boolean hasInitContainers();
    public V1PodSpecFluent.InitContainersNested<A> addNewInitContainer();
    public V1PodSpecFluent.InitContainersNested<A> addNewInitContainerLike(V1Container item);
    public V1PodSpecFluent.InitContainersNested<A> setNewInitContainerLike(int index,V1Container item);
    public V1PodSpecFluent.InitContainersNested<A> editInitContainer(int index);
    public V1PodSpecFluent.InitContainersNested<A> editFirstInitContainer();
    public V1PodSpecFluent.InitContainersNested<A> editLastInitContainer();
    public V1PodSpecFluent.InitContainersNested<A> editMatchingInitContainer(io.kubernetes.client.fluent.Predicate<V1ContainerBuilder> predicate);
    public String getNodeName();
    public A withNodeName(String nodeName);
    public Boolean hasNodeName();
    public A addToNodeSelector(String key,String value);
    public A addToNodeSelector(Map<String,String> map);
    public A removeFromNodeSelector(String key);
    public A removeFromNodeSelector(Map<String,String> map);
    public Map<String,String> getNodeSelector();
    public A withNodeSelector(Map<String,String> nodeSelector);
    public Boolean hasNodeSelector();
    public Integer getPriority();
    public A withPriority(Integer priority);
    public Boolean hasPriority();
    public A withNewPriority(int arg1);
    public A withNewPriority(String arg1);
    public String getPriorityClassName();
    public A withPriorityClassName(String priorityClassName);
    public Boolean hasPriorityClassName();
    public A addToReadinessGates(int index,V1PodReadinessGate item);
    public A setToReadinessGates(int index,V1PodReadinessGate item);
    public A addToReadinessGates(V1PodReadinessGate... items);
    public A addAllToReadinessGates(Collection<V1PodReadinessGate> items);
    public A removeFromReadinessGates(V1PodReadinessGate... items);
    public A removeAllFromReadinessGates(Collection<V1PodReadinessGate> items);
    
/**
 * This method has been deprecated, please use method buildReadinessGates instead.
 * @return The buildable object.
 */
@Deprecated public List<V1PodReadinessGate> getReadinessGates();
    public List<V1PodReadinessGate> buildReadinessGates();
    public V1PodReadinessGate buildReadinessGate(int index);
    public V1PodReadinessGate buildFirstReadinessGate();
    public V1PodReadinessGate buildLastReadinessGate();
    public V1PodReadinessGate buildMatchingReadinessGate(io.kubernetes.client.fluent.Predicate<V1PodReadinessGateBuilder> predicate);
    public A withReadinessGates(List<V1PodReadinessGate> readinessGates);
    public A withReadinessGates(V1PodReadinessGate... readinessGates);
    public Boolean hasReadinessGates();
    public V1PodSpecFluent.ReadinessGatesNested<A> addNewReadinessGate();
    public V1PodSpecFluent.ReadinessGatesNested<A> addNewReadinessGateLike(V1PodReadinessGate item);
    public V1PodSpecFluent.ReadinessGatesNested<A> setNewReadinessGateLike(int index,V1PodReadinessGate item);
    public V1PodSpecFluent.ReadinessGatesNested<A> editReadinessGate(int index);
    public V1PodSpecFluent.ReadinessGatesNested<A> editFirstReadinessGate();
    public V1PodSpecFluent.ReadinessGatesNested<A> editLastReadinessGate();
    public V1PodSpecFluent.ReadinessGatesNested<A> editMatchingReadinessGate(io.kubernetes.client.fluent.Predicate<V1PodReadinessGateBuilder> predicate);
    public String getRestartPolicy();
    public A withRestartPolicy(String restartPolicy);
    public Boolean hasRestartPolicy();
    public String getSchedulerName();
    public A withSchedulerName(String schedulerName);
    public Boolean hasSchedulerName();
    
/**
 * This method has been deprecated, please use method buildSecurityContext instead.
 * @return The buildable object.
 */
@Deprecated public V1PodSecurityContext getSecurityContext();
    public V1PodSecurityContext buildSecurityContext();
    public A withSecurityContext(V1PodSecurityContext securityContext);
    public Boolean hasSecurityContext();
    public V1PodSpecFluent.SecurityContextNested<A> withNewSecurityContext();
    public V1PodSpecFluent.SecurityContextNested<A> withNewSecurityContextLike(V1PodSecurityContext item);
    public V1PodSpecFluent.SecurityContextNested<A> editSecurityContext();
    public V1PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContext();
    public V1PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContextLike(V1PodSecurityContext item);
    public String getServiceAccount();
    public A withServiceAccount(String serviceAccount);
    public Boolean hasServiceAccount();
    public String getServiceAccountName();
    public A withServiceAccountName(String serviceAccountName);
    public Boolean hasServiceAccountName();
    public Boolean isShareProcessNamespace();
    public A withShareProcessNamespace(Boolean shareProcessNamespace);
    public Boolean hasShareProcessNamespace();
    public A withNewShareProcessNamespace(boolean arg1);
    public A withNewShareProcessNamespace(String arg1);
    public String getSubdomain();
    public A withSubdomain(String subdomain);
    public Boolean hasSubdomain();
    public Long getTerminationGracePeriodSeconds();
    public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds);
    public Boolean hasTerminationGracePeriodSeconds();
    public A withNewTerminationGracePeriodSeconds(String arg1);
    public A withNewTerminationGracePeriodSeconds(long arg1);
    public A addToTolerations(int index,V1Toleration item);
    public A setToTolerations(int index,V1Toleration item);
    public A addToTolerations(V1Toleration... items);
    public A addAllToTolerations(Collection<V1Toleration> items);
    public A removeFromTolerations(V1Toleration... items);
    public A removeAllFromTolerations(Collection<V1Toleration> items);
    
/**
 * This method has been deprecated, please use method buildTolerations instead.
 * @return The buildable object.
 */
@Deprecated public List<V1Toleration> getTolerations();
    public List<V1Toleration> buildTolerations();
    public V1Toleration buildToleration(int index);
    public V1Toleration buildFirstToleration();
    public V1Toleration buildLastToleration();
    public V1Toleration buildMatchingToleration(io.kubernetes.client.fluent.Predicate<V1TolerationBuilder> predicate);
    public A withTolerations(List<V1Toleration> tolerations);
    public A withTolerations(V1Toleration... tolerations);
    public Boolean hasTolerations();
    public V1PodSpecFluent.TolerationsNested<A> addNewToleration();
    public V1PodSpecFluent.TolerationsNested<A> addNewTolerationLike(V1Toleration item);
    public V1PodSpecFluent.TolerationsNested<A> setNewTolerationLike(int index,V1Toleration item);
    public V1PodSpecFluent.TolerationsNested<A> editToleration(int index);
    public V1PodSpecFluent.TolerationsNested<A> editFirstToleration();
    public V1PodSpecFluent.TolerationsNested<A> editLastToleration();
    public V1PodSpecFluent.TolerationsNested<A> editMatchingToleration(io.kubernetes.client.fluent.Predicate<V1TolerationBuilder> predicate);
    public A addToVolumes(int index,V1Volume item);
    public A setToVolumes(int index,V1Volume item);
    public A addToVolumes(V1Volume... items);
    public A addAllToVolumes(Collection<V1Volume> items);
    public A removeFromVolumes(V1Volume... items);
    public A removeAllFromVolumes(Collection<V1Volume> items);
    
/**
 * This method has been deprecated, please use method buildVolumes instead.
 * @return The buildable object.
 */
@Deprecated public List<V1Volume> getVolumes();
    public List<V1Volume> buildVolumes();
    public V1Volume buildVolume(int index);
    public V1Volume buildFirstVolume();
    public V1Volume buildLastVolume();
    public V1Volume buildMatchingVolume(io.kubernetes.client.fluent.Predicate<V1VolumeBuilder> predicate);
    public A withVolumes(List<V1Volume> volumes);
    public A withVolumes(V1Volume... volumes);
    public Boolean hasVolumes();
    public V1PodSpecFluent.VolumesNested<A> addNewVolume();
    public V1PodSpecFluent.VolumesNested<A> addNewVolumeLike(V1Volume item);
    public V1PodSpecFluent.VolumesNested<A> setNewVolumeLike(int index,V1Volume item);
    public V1PodSpecFluent.VolumesNested<A> editVolume(int index);
    public V1PodSpecFluent.VolumesNested<A> editFirstVolume();
    public V1PodSpecFluent.VolumesNested<A> editLastVolume();
    public V1PodSpecFluent.VolumesNested<A> editMatchingVolume(io.kubernetes.client.fluent.Predicate<V1VolumeBuilder> predicate);

    public interface AffinityNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1AffinityFluent<V1PodSpecFluent.AffinityNested<N>>{

        
    public N and();    public N endAffinity();
}
    public interface ContainersNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ContainerFluent<V1PodSpecFluent.ContainersNested<N>>{

        
    public N and();    public N endContainer();
}
    public interface DnsConfigNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1PodDNSConfigFluent<V1PodSpecFluent.DnsConfigNested<N>>{

        
    public N and();    public N endDnsConfig();
}
    public interface HostAliasesNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1HostAliasFluent<V1PodSpecFluent.HostAliasesNested<N>>{

        
    public N and();    public N endHostAlias();
}
    public interface ImagePullSecretsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1LocalObjectReferenceFluent<V1PodSpecFluent.ImagePullSecretsNested<N>>{

        
    public N and();    public N endImagePullSecret();
}
    public interface InitContainersNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ContainerFluent<V1PodSpecFluent.InitContainersNested<N>>{

        
    public N and();    public N endInitContainer();
}
    public interface ReadinessGatesNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1PodReadinessGateFluent<V1PodSpecFluent.ReadinessGatesNested<N>>{

        
    public N and();    public N endReadinessGate();
}
    public interface SecurityContextNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1PodSecurityContextFluent<V1PodSpecFluent.SecurityContextNested<N>>{

        
    public N and();    public N endSecurityContext();
}
    public interface TolerationsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1TolerationFluent<V1PodSpecFluent.TolerationsNested<N>>{

        
    public N and();    public N endToleration();
}
    public interface VolumesNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1VolumeFluent<V1PodSpecFluent.VolumesNested<N>>{

        
    public N and();    public N endVolume();
}


}
