package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1PodTemplateFluentImpl<A extends V1PodTemplateFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1PodTemplateFluent<A>{

    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1PodTemplateSpecBuilder template;

    public V1PodTemplateFluentImpl(){
    }
    public V1PodTemplateFluentImpl(V1PodTemplate instance){
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withTemplate(instance.getTemplate());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public V1PodTemplateFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public V1PodTemplateFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public V1PodTemplateFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public V1PodTemplateFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public V1PodTemplateFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public V1PodTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public V1PodTemplateSpec buildTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(V1PodTemplateSpec template){
            _visitables.remove(this.template);
            if (template!=null){ this.template= new V1PodTemplateSpecBuilder(template); _visitables.add(this.template);} return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template != null;
    }

    public V1PodTemplateFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public V1PodTemplateFluent.TemplateNested<A> withNewTemplateLike(V1PodTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public V1PodTemplateFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public V1PodTemplateFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new V1PodTemplateSpecBuilder().build());
    }

    public V1PodTemplateFluent.TemplateNested<A> editOrNewTemplateLike(V1PodTemplateSpec item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1PodTemplateFluentImpl that = (V1PodTemplateFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<V1PodTemplateFluent.MetadataNested<N>> implements V1PodTemplateFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectMetaBuilder builder;
    
            MetadataNestedImpl(V1ObjectMeta item){
                    this.builder = new V1ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) V1PodTemplateFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends V1PodTemplateSpecFluentImpl<V1PodTemplateFluent.TemplateNested<N>> implements V1PodTemplateFluent.TemplateNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1PodTemplateSpecBuilder builder;
    
            TemplateNestedImpl(V1PodTemplateSpec item){
                    this.builder = new V1PodTemplateSpecBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new V1PodTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) V1PodTemplateFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}


}
