package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class V1SecretFluentImpl<A extends V1SecretFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1SecretFluent<A>{

    private String apiVersion;
    private Map<String,byte[]> data;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private Map<String,String> stringData;
    private String type;

    public V1SecretFluentImpl(){
    }
    public V1SecretFluentImpl(V1Secret instance){
            this.withApiVersion(instance.getApiVersion());

            this.withData(instance.getData());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withStringData(instance.getStringData());

            this.withType(instance.getType());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A addToData(String key,byte[] value){
            if(this.data == null && key != null && value != null) { this.data = new LinkedHashMap<String,byte[]>(); }
            if(key != null && value != null) {this.data.put(key, value);} return (A)this;
    }

    public A addToData(Map<String,byte[]> map){
            if(this.data == null && map != null) { this.data = new LinkedHashMap<String,byte[]>(); }
            if(map != null) { this.data.putAll(map);} return (A)this;
    }

    public A removeFromData(String key){
            if(this.data == null) { return (A) this; }
            if(key != null && this.data != null) {this.data.remove(key);} return (A)this;
    }

    public A removeFromData(Map<String,byte[]> map){
            if(this.data == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.data != null){this.data.remove(key);}}} return (A)this;
    }

    public Map<String,byte[]> getData(){
            return this.data;
    }

    public A withData(Map<String,byte[]> data){
            if (data == null) { this.data =  null;} else {this.data = new LinkedHashMap<String,byte[]>(data);} return (A) this;
    }

    public Boolean hasData(){
            return this.data != null;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public V1SecretFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public V1SecretFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public V1SecretFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public V1SecretFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public V1SecretFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToStringData(String key,String value){
            if(this.stringData == null && key != null && value != null) { this.stringData = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.stringData.put(key, value);} return (A)this;
    }

    public A addToStringData(Map<String,String> map){
            if(this.stringData == null && map != null) { this.stringData = new LinkedHashMap<String,String>(); }
            if(map != null) { this.stringData.putAll(map);} return (A)this;
    }

    public A removeFromStringData(String key){
            if(this.stringData == null) { return (A) this; }
            if(key != null && this.stringData != null) {this.stringData.remove(key);} return (A)this;
    }

    public A removeFromStringData(Map<String,String> map){
            if(this.stringData == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.stringData != null){this.stringData.remove(key);}}} return (A)this;
    }

    public Map<String,String> getStringData(){
            return this.stringData;
    }

    public A withStringData(Map<String,String> stringData){
            if (stringData == null) { this.stringData =  null;} else {this.stringData = new LinkedHashMap<String,String>(stringData);} return (A) this;
    }

    public Boolean hasStringData(){
            return this.stringData != null;
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1SecretFluentImpl that = (V1SecretFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (data != null ? !data.equals(that.data) :that.data != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (stringData != null ? !stringData.equals(that.stringData) :that.stringData != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<V1SecretFluent.MetadataNested<N>> implements V1SecretFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectMetaBuilder builder;
    
            MetadataNestedImpl(V1ObjectMeta item){
                    this.builder = new V1ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) V1SecretFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
