package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1TopologySelectorTermFluentImpl<A extends V1TopologySelectorTermFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1TopologySelectorTermFluent<A>{

    private List<V1TopologySelectorLabelRequirementBuilder> matchLabelExpressions;

    public V1TopologySelectorTermFluentImpl(){
    }
    public V1TopologySelectorTermFluentImpl(V1TopologySelectorTerm instance){
            this.withMatchLabelExpressions(instance.getMatchLabelExpressions());

    }

    public A addToMatchLabelExpressions(int index,V1TopologySelectorLabelRequirement item){
            if (this.matchLabelExpressions == null) {this.matchLabelExpressions = new ArrayList<V1TopologySelectorLabelRequirementBuilder>();}
            V1TopologySelectorLabelRequirementBuilder builder = new V1TopologySelectorLabelRequirementBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.matchLabelExpressions.add(index >= 0 ? index : matchLabelExpressions.size(), builder); return (A)this;
    }

    public A setToMatchLabelExpressions(int index,V1TopologySelectorLabelRequirement item){
            if (this.matchLabelExpressions == null) {this.matchLabelExpressions = new ArrayList<V1TopologySelectorLabelRequirementBuilder>();}
            V1TopologySelectorLabelRequirementBuilder builder = new V1TopologySelectorLabelRequirementBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= matchLabelExpressions.size()) { matchLabelExpressions.add(builder); } else { matchLabelExpressions.set(index, builder);}
             return (A)this;
    }

    public A addToMatchLabelExpressions(V1TopologySelectorLabelRequirement... items){
            if (this.matchLabelExpressions == null) {this.matchLabelExpressions = new ArrayList<V1TopologySelectorLabelRequirementBuilder>();}
            for (V1TopologySelectorLabelRequirement item : items) {V1TopologySelectorLabelRequirementBuilder builder = new V1TopologySelectorLabelRequirementBuilder(item);_visitables.add(builder);this.matchLabelExpressions.add(builder);} return (A)this;
    }

    public A addAllToMatchLabelExpressions(Collection<V1TopologySelectorLabelRequirement> items){
            if (this.matchLabelExpressions == null) {this.matchLabelExpressions = new ArrayList<V1TopologySelectorLabelRequirementBuilder>();}
            for (V1TopologySelectorLabelRequirement item : items) {V1TopologySelectorLabelRequirementBuilder builder = new V1TopologySelectorLabelRequirementBuilder(item);_visitables.add(builder);this.matchLabelExpressions.add(builder);} return (A)this;
    }

    public A removeFromMatchLabelExpressions(V1TopologySelectorLabelRequirement... items){
            for (V1TopologySelectorLabelRequirement item : items) {V1TopologySelectorLabelRequirementBuilder builder = new V1TopologySelectorLabelRequirementBuilder(item);_visitables.remove(builder);if (this.matchLabelExpressions != null) {this.matchLabelExpressions.remove(builder);}} return (A)this;
    }

    public A removeAllFromMatchLabelExpressions(Collection<V1TopologySelectorLabelRequirement> items){
            for (V1TopologySelectorLabelRequirement item : items) {V1TopologySelectorLabelRequirementBuilder builder = new V1TopologySelectorLabelRequirementBuilder(item);_visitables.remove(builder);if (this.matchLabelExpressions != null) {this.matchLabelExpressions.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildMatchLabelExpressions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1TopologySelectorLabelRequirement> getMatchLabelExpressions(){
            return build(matchLabelExpressions);
    }

    public List<V1TopologySelectorLabelRequirement> buildMatchLabelExpressions(){
            return build(matchLabelExpressions);
    }

    public V1TopologySelectorLabelRequirement buildMatchLabelExpression(int index){
            return this.matchLabelExpressions.get(index).build();
    }

    public V1TopologySelectorLabelRequirement buildFirstMatchLabelExpression(){
            return this.matchLabelExpressions.get(0).build();
    }

    public V1TopologySelectorLabelRequirement buildLastMatchLabelExpression(){
            return this.matchLabelExpressions.get(matchLabelExpressions.size() - 1).build();
    }

    public V1TopologySelectorLabelRequirement buildMatchingMatchLabelExpression(io.kubernetes.client.fluent.Predicate<V1TopologySelectorLabelRequirementBuilder> predicate){
            for (V1TopologySelectorLabelRequirementBuilder item: matchLabelExpressions) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withMatchLabelExpressions(List<V1TopologySelectorLabelRequirement> matchLabelExpressions){
            if (this.matchLabelExpressions != null) { _visitables.removeAll(this.matchLabelExpressions);}
            if (matchLabelExpressions != null) {this.matchLabelExpressions = new ArrayList<V1TopologySelectorLabelRequirementBuilder>(); for (V1TopologySelectorLabelRequirement item : matchLabelExpressions){this.addToMatchLabelExpressions(item);}} else { this.matchLabelExpressions = null;} return (A) this;
    }

    public A withMatchLabelExpressions(V1TopologySelectorLabelRequirement... matchLabelExpressions){
            if (this.matchLabelExpressions != null) {this.matchLabelExpressions.clear();}
            if (matchLabelExpressions != null) {for (V1TopologySelectorLabelRequirement item :matchLabelExpressions){ this.addToMatchLabelExpressions(item);}} return (A) this;
    }

    public Boolean hasMatchLabelExpressions(){
            return matchLabelExpressions != null && !matchLabelExpressions.isEmpty();
    }

    public V1TopologySelectorTermFluent.MatchLabelExpressionsNested<A> addNewMatchLabelExpression(){
            return new MatchLabelExpressionsNestedImpl();
    }

    public V1TopologySelectorTermFluent.MatchLabelExpressionsNested<A> addNewMatchLabelExpressionLike(V1TopologySelectorLabelRequirement item){
            return new MatchLabelExpressionsNestedImpl(-1, item);
    }

    public V1TopologySelectorTermFluent.MatchLabelExpressionsNested<A> setNewMatchLabelExpressionLike(int index,V1TopologySelectorLabelRequirement item){
            return new MatchLabelExpressionsNestedImpl(index, item);
    }

    public V1TopologySelectorTermFluent.MatchLabelExpressionsNested<A> editMatchLabelExpression(int index){
            if (matchLabelExpressions.size() <= index) throw new RuntimeException("Can't edit matchLabelExpressions. Index exceeds size.");
            return setNewMatchLabelExpressionLike(index, buildMatchLabelExpression(index));
    }

    public V1TopologySelectorTermFluent.MatchLabelExpressionsNested<A> editFirstMatchLabelExpression(){
            if (matchLabelExpressions.size() == 0) throw new RuntimeException("Can't edit first matchLabelExpressions. The list is empty.");
            return setNewMatchLabelExpressionLike(0, buildMatchLabelExpression(0));
    }

    public V1TopologySelectorTermFluent.MatchLabelExpressionsNested<A> editLastMatchLabelExpression(){
            int index = matchLabelExpressions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last matchLabelExpressions. The list is empty.");
            return setNewMatchLabelExpressionLike(index, buildMatchLabelExpression(index));
    }

    public V1TopologySelectorTermFluent.MatchLabelExpressionsNested<A> editMatchingMatchLabelExpression(io.kubernetes.client.fluent.Predicate<V1TopologySelectorLabelRequirementBuilder> predicate){
            int index = -1;
            for (int i=0;i<matchLabelExpressions.size();i++) { 
            if (predicate.apply(matchLabelExpressions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching matchLabelExpressions. No match found.");
            return setNewMatchLabelExpressionLike(index, buildMatchLabelExpression(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1TopologySelectorTermFluentImpl that = (V1TopologySelectorTermFluentImpl) o;
            if (matchLabelExpressions != null ? !matchLabelExpressions.equals(that.matchLabelExpressions) :that.matchLabelExpressions != null) return false;
            return true;
    }


    public class MatchLabelExpressionsNestedImpl<N> extends V1TopologySelectorLabelRequirementFluentImpl<V1TopologySelectorTermFluent.MatchLabelExpressionsNested<N>> implements V1TopologySelectorTermFluent.MatchLabelExpressionsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1TopologySelectorLabelRequirementBuilder builder;
        private final int index;
    
            MatchLabelExpressionsNestedImpl(int index,V1TopologySelectorLabelRequirement item){
                    this.index = index;
                    this.builder = new V1TopologySelectorLabelRequirementBuilder(this, item);
            }
            MatchLabelExpressionsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1TopologySelectorLabelRequirementBuilder(this);
            }
    
    public N and(){
            return (N) V1TopologySelectorTermFluentImpl.this.setToMatchLabelExpressions(index, builder.build());
    }
    public N endMatchLabelExpression(){
            return and();
    }

}


}
