package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1alpha1RoleFluent<A extends V1alpha1RoleFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata();
    public V1ObjectMeta buildMetadata();
    public A withMetadata(V1ObjectMeta metadata);
    public Boolean hasMetadata();
    public V1alpha1RoleFluent.MetadataNested<A> withNewMetadata();
    public V1alpha1RoleFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item);
    public V1alpha1RoleFluent.MetadataNested<A> editMetadata();
    public V1alpha1RoleFluent.MetadataNested<A> editOrNewMetadata();
    public V1alpha1RoleFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item);
    public A addToRules(int index,V1alpha1PolicyRule item);
    public A setToRules(int index,V1alpha1PolicyRule item);
    public A addToRules(V1alpha1PolicyRule... items);
    public A addAllToRules(Collection<V1alpha1PolicyRule> items);
    public A removeFromRules(V1alpha1PolicyRule... items);
    public A removeAllFromRules(Collection<V1alpha1PolicyRule> items);
    
/**
 * This method has been deprecated, please use method buildRules instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PolicyRule> getRules();
    public List<V1alpha1PolicyRule> buildRules();
    public V1alpha1PolicyRule buildRule(int index);
    public V1alpha1PolicyRule buildFirstRule();
    public V1alpha1PolicyRule buildLastRule();
    public V1alpha1PolicyRule buildMatchingRule(io.kubernetes.client.fluent.Predicate<V1alpha1PolicyRuleBuilder> predicate);
    public A withRules(List<V1alpha1PolicyRule> rules);
    public A withRules(V1alpha1PolicyRule... rules);
    public Boolean hasRules();
    public V1alpha1RoleFluent.RulesNested<A> addNewRule();
    public V1alpha1RoleFluent.RulesNested<A> addNewRuleLike(V1alpha1PolicyRule item);
    public V1alpha1RoleFluent.RulesNested<A> setNewRuleLike(int index,V1alpha1PolicyRule item);
    public V1alpha1RoleFluent.RulesNested<A> editRule(int index);
    public V1alpha1RoleFluent.RulesNested<A> editFirstRule();
    public V1alpha1RoleFluent.RulesNested<A> editLastRule();
    public V1alpha1RoleFluent.RulesNested<A> editMatchingRule(io.kubernetes.client.fluent.Predicate<V1alpha1PolicyRuleBuilder> predicate);

    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectMetaFluent<V1alpha1RoleFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface RulesNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1alpha1PolicyRuleFluent<V1alpha1RoleFluent.RulesNested<N>>{

        
    public N and();    public N endRule();
}


}
