package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1beta1CustomResourceDefinitionStatusFluentImpl<A extends V1beta1CustomResourceDefinitionStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1CustomResourceDefinitionStatusFluent<A>{

    private V1beta1CustomResourceDefinitionNamesBuilder acceptedNames;
    private List<V1beta1CustomResourceDefinitionConditionBuilder> conditions;
    private List<String> storedVersions;

    public V1beta1CustomResourceDefinitionStatusFluentImpl(){
    }
    public V1beta1CustomResourceDefinitionStatusFluentImpl(V1beta1CustomResourceDefinitionStatus instance){
            this.withAcceptedNames(instance.getAcceptedNames());

            this.withConditions(instance.getConditions());

            this.withStoredVersions(instance.getStoredVersions());

    }

    
/**
 * This method has been deprecated, please use method buildAcceptedNames instead.
 * @return The buildable object.
 */
@Deprecated public V1beta1CustomResourceDefinitionNames getAcceptedNames(){
            return this.acceptedNames!=null?this.acceptedNames.build():null;
    }

    public V1beta1CustomResourceDefinitionNames buildAcceptedNames(){
            return this.acceptedNames!=null?this.acceptedNames.build():null;
    }

    public A withAcceptedNames(V1beta1CustomResourceDefinitionNames acceptedNames){
            _visitables.remove(this.acceptedNames);
            if (acceptedNames!=null){ this.acceptedNames= new V1beta1CustomResourceDefinitionNamesBuilder(acceptedNames); _visitables.add(this.acceptedNames);} return (A) this;
    }

    public Boolean hasAcceptedNames(){
            return this.acceptedNames != null;
    }

    public V1beta1CustomResourceDefinitionStatusFluent.AcceptedNamesNested<A> withNewAcceptedNames(){
            return new AcceptedNamesNestedImpl();
    }

    public V1beta1CustomResourceDefinitionStatusFluent.AcceptedNamesNested<A> withNewAcceptedNamesLike(V1beta1CustomResourceDefinitionNames item){
            return new AcceptedNamesNestedImpl(item);
    }

    public V1beta1CustomResourceDefinitionStatusFluent.AcceptedNamesNested<A> editAcceptedNames(){
            return withNewAcceptedNamesLike(getAcceptedNames());
    }

    public V1beta1CustomResourceDefinitionStatusFluent.AcceptedNamesNested<A> editOrNewAcceptedNames(){
            return withNewAcceptedNamesLike(getAcceptedNames() != null ? getAcceptedNames(): new V1beta1CustomResourceDefinitionNamesBuilder().build());
    }

    public V1beta1CustomResourceDefinitionStatusFluent.AcceptedNamesNested<A> editOrNewAcceptedNamesLike(V1beta1CustomResourceDefinitionNames item){
            return withNewAcceptedNamesLike(getAcceptedNames() != null ? getAcceptedNames(): item);
    }

    public A addToConditions(int index,V1beta1CustomResourceDefinitionCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<V1beta1CustomResourceDefinitionConditionBuilder>();}
            V1beta1CustomResourceDefinitionConditionBuilder builder = new V1beta1CustomResourceDefinitionConditionBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,V1beta1CustomResourceDefinitionCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<V1beta1CustomResourceDefinitionConditionBuilder>();}
            V1beta1CustomResourceDefinitionConditionBuilder builder = new V1beta1CustomResourceDefinitionConditionBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(V1beta1CustomResourceDefinitionCondition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<V1beta1CustomResourceDefinitionConditionBuilder>();}
            for (V1beta1CustomResourceDefinitionCondition item : items) {V1beta1CustomResourceDefinitionConditionBuilder builder = new V1beta1CustomResourceDefinitionConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<V1beta1CustomResourceDefinitionCondition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<V1beta1CustomResourceDefinitionConditionBuilder>();}
            for (V1beta1CustomResourceDefinitionCondition item : items) {V1beta1CustomResourceDefinitionConditionBuilder builder = new V1beta1CustomResourceDefinitionConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(V1beta1CustomResourceDefinitionCondition... items){
            for (V1beta1CustomResourceDefinitionCondition item : items) {V1beta1CustomResourceDefinitionConditionBuilder builder = new V1beta1CustomResourceDefinitionConditionBuilder(item);_visitables.remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<V1beta1CustomResourceDefinitionCondition> items){
            for (V1beta1CustomResourceDefinitionCondition item : items) {V1beta1CustomResourceDefinitionConditionBuilder builder = new V1beta1CustomResourceDefinitionConditionBuilder(item);_visitables.remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1CustomResourceDefinitionCondition> getConditions(){
            return build(conditions);
    }

    public List<V1beta1CustomResourceDefinitionCondition> buildConditions(){
            return build(conditions);
    }

    public V1beta1CustomResourceDefinitionCondition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public V1beta1CustomResourceDefinitionCondition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public V1beta1CustomResourceDefinitionCondition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public V1beta1CustomResourceDefinitionCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V1beta1CustomResourceDefinitionConditionBuilder> predicate){
            for (V1beta1CustomResourceDefinitionConditionBuilder item: conditions) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withConditions(List<V1beta1CustomResourceDefinitionCondition> conditions){
            if (this.conditions != null) { _visitables.removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<V1beta1CustomResourceDefinitionConditionBuilder>(); for (V1beta1CustomResourceDefinitionCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(V1beta1CustomResourceDefinitionCondition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (V1beta1CustomResourceDefinitionCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public V1beta1CustomResourceDefinitionStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public V1beta1CustomResourceDefinitionStatusFluent.ConditionsNested<A> addNewConditionLike(V1beta1CustomResourceDefinitionCondition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public V1beta1CustomResourceDefinitionStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1beta1CustomResourceDefinitionCondition item){
            return new ConditionsNestedImpl(index, item);
    }

    public V1beta1CustomResourceDefinitionStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public V1beta1CustomResourceDefinitionStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public V1beta1CustomResourceDefinitionStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public V1beta1CustomResourceDefinitionStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V1beta1CustomResourceDefinitionConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public A addToStoredVersions(int index,String item){
            if (this.storedVersions == null) {this.storedVersions = new ArrayList<String>();}
            this.storedVersions.add(index, item);
            return (A)this;
    }

    public A setToStoredVersions(int index,String item){
            if (this.storedVersions == null) {this.storedVersions = new ArrayList<String>();}
            this.storedVersions.set(index, item); return (A)this;
    }

    public A addToStoredVersions(String... items){
            if (this.storedVersions == null) {this.storedVersions = new ArrayList<String>();}
            for (String item : items) {this.storedVersions.add(item);} return (A)this;
    }

    public A addAllToStoredVersions(Collection<String> items){
            if (this.storedVersions == null) {this.storedVersions = new ArrayList<String>();}
            for (String item : items) {this.storedVersions.add(item);} return (A)this;
    }

    public A removeFromStoredVersions(String... items){
            for (String item : items) {if (this.storedVersions!= null){ this.storedVersions.remove(item);}} return (A)this;
    }

    public A removeAllFromStoredVersions(Collection<String> items){
            for (String item : items) {if (this.storedVersions!= null){ this.storedVersions.remove(item);}} return (A)this;
    }

    public List<String> getStoredVersions(){
            return this.storedVersions;
    }

    public String getStoredVersion(int index){
            return this.storedVersions.get(index);
    }

    public String getFirstStoredVersion(){
            return this.storedVersions.get(0);
    }

    public String getLastStoredVersion(){
            return this.storedVersions.get(storedVersions.size() - 1);
    }

    public String getMatchingStoredVersion(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: storedVersions) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withStoredVersions(List<String> storedVersions){
            if (this.storedVersions != null) { _visitables.removeAll(this.storedVersions);}
            if (storedVersions != null) {this.storedVersions = new ArrayList<String>(); for (String item : storedVersions){this.addToStoredVersions(item);}} else { this.storedVersions = null;} return (A) this;
    }

    public A withStoredVersions(String... storedVersions){
            if (this.storedVersions != null) {this.storedVersions.clear();}
            if (storedVersions != null) {for (String item :storedVersions){ this.addToStoredVersions(item);}} return (A) this;
    }

    public Boolean hasStoredVersions(){
            return storedVersions != null && !storedVersions.isEmpty();
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1CustomResourceDefinitionStatusFluentImpl that = (V1beta1CustomResourceDefinitionStatusFluentImpl) o;
            if (acceptedNames != null ? !acceptedNames.equals(that.acceptedNames) :that.acceptedNames != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (storedVersions != null ? !storedVersions.equals(that.storedVersions) :that.storedVersions != null) return false;
            return true;
    }


    public class AcceptedNamesNestedImpl<N> extends V1beta1CustomResourceDefinitionNamesFluentImpl<V1beta1CustomResourceDefinitionStatusFluent.AcceptedNamesNested<N>> implements V1beta1CustomResourceDefinitionStatusFluent.AcceptedNamesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1CustomResourceDefinitionNamesBuilder builder;
    
            AcceptedNamesNestedImpl(V1beta1CustomResourceDefinitionNames item){
                    this.builder = new V1beta1CustomResourceDefinitionNamesBuilder(this, item);
            }
            AcceptedNamesNestedImpl(){
                    this.builder = new V1beta1CustomResourceDefinitionNamesBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1CustomResourceDefinitionStatusFluentImpl.this.withAcceptedNames(builder.build());
    }
    public N endAcceptedNames(){
            return and();
    }

}
    public class ConditionsNestedImpl<N> extends V1beta1CustomResourceDefinitionConditionFluentImpl<V1beta1CustomResourceDefinitionStatusFluent.ConditionsNested<N>> implements V1beta1CustomResourceDefinitionStatusFluent.ConditionsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1CustomResourceDefinitionConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,V1beta1CustomResourceDefinitionCondition item){
                    this.index = index;
                    this.builder = new V1beta1CustomResourceDefinitionConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1beta1CustomResourceDefinitionConditionBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1CustomResourceDefinitionStatusFluentImpl.this.setToConditions(index, builder.build());
    }
    public N endCondition(){
            return and();
    }

}


}
