package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1CustomResourceDefinitionVersionBuilder extends V1beta1CustomResourceDefinitionVersionFluentImpl<V1beta1CustomResourceDefinitionVersionBuilder> implements VisitableBuilder<V1beta1CustomResourceDefinitionVersion,V1beta1CustomResourceDefinitionVersionBuilder>{

    V1beta1CustomResourceDefinitionVersionFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1CustomResourceDefinitionVersionBuilder(){
            this(true);
    }
    public V1beta1CustomResourceDefinitionVersionBuilder(Boolean validationEnabled){
            this(new V1beta1CustomResourceDefinitionVersion(), validationEnabled);
    }
    public V1beta1CustomResourceDefinitionVersionBuilder(V1beta1CustomResourceDefinitionVersionFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1CustomResourceDefinitionVersionBuilder(V1beta1CustomResourceDefinitionVersionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1CustomResourceDefinitionVersion(), validationEnabled);
    }
    public V1beta1CustomResourceDefinitionVersionBuilder(V1beta1CustomResourceDefinitionVersionFluent<?> fluent,V1beta1CustomResourceDefinitionVersion instance){
            this(fluent, instance, true);
    }
    public V1beta1CustomResourceDefinitionVersionBuilder(V1beta1CustomResourceDefinitionVersionFluent<?> fluent,V1beta1CustomResourceDefinitionVersion instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            fluent.withServed(instance.isServed());

            fluent.withStorage(instance.isStorage());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1CustomResourceDefinitionVersionBuilder(V1beta1CustomResourceDefinitionVersion instance){
            this(instance,true);
    }
    public V1beta1CustomResourceDefinitionVersionBuilder(V1beta1CustomResourceDefinitionVersion instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.withServed(instance.isServed());

            this.withStorage(instance.isStorage());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1CustomResourceDefinitionVersion build(){
            V1beta1CustomResourceDefinitionVersion buildable = new V1beta1CustomResourceDefinitionVersion();
            buildable.setName(fluent.getName());
            buildable.setServed(fluent.isServed());
            buildable.setStorage(fluent.isStorage());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1CustomResourceDefinitionVersionBuilder that = (V1beta1CustomResourceDefinitionVersionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
