package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1EvictionFluentImpl<A extends V1beta1EvictionFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1EvictionFluent<A>{

    private String apiVersion;
    private V1DeleteOptionsBuilder deleteOptions;
    private String kind;
    private V1ObjectMetaBuilder metadata;

    public V1beta1EvictionFluentImpl(){
    }
    public V1beta1EvictionFluentImpl(V1beta1Eviction instance){
            this.withApiVersion(instance.getApiVersion());

            this.withDeleteOptions(instance.getDeleteOptions());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    
/**
 * This method has been deprecated, please use method buildDeleteOptions instead.
 * @return The buildable object.
 */
@Deprecated public V1DeleteOptions getDeleteOptions(){
            return this.deleteOptions!=null?this.deleteOptions.build():null;
    }

    public V1DeleteOptions buildDeleteOptions(){
            return this.deleteOptions!=null?this.deleteOptions.build():null;
    }

    public A withDeleteOptions(V1DeleteOptions deleteOptions){
            _visitables.remove(this.deleteOptions);
            if (deleteOptions!=null){ this.deleteOptions= new V1DeleteOptionsBuilder(deleteOptions); _visitables.add(this.deleteOptions);} return (A) this;
    }

    public Boolean hasDeleteOptions(){
            return this.deleteOptions != null;
    }

    public V1beta1EvictionFluent.DeleteOptionsNested<A> withNewDeleteOptions(){
            return new DeleteOptionsNestedImpl();
    }

    public V1beta1EvictionFluent.DeleteOptionsNested<A> withNewDeleteOptionsLike(V1DeleteOptions item){
            return new DeleteOptionsNestedImpl(item);
    }

    public V1beta1EvictionFluent.DeleteOptionsNested<A> editDeleteOptions(){
            return withNewDeleteOptionsLike(getDeleteOptions());
    }

    public V1beta1EvictionFluent.DeleteOptionsNested<A> editOrNewDeleteOptions(){
            return withNewDeleteOptionsLike(getDeleteOptions() != null ? getDeleteOptions(): new V1DeleteOptionsBuilder().build());
    }

    public V1beta1EvictionFluent.DeleteOptionsNested<A> editOrNewDeleteOptionsLike(V1DeleteOptions item){
            return withNewDeleteOptionsLike(getDeleteOptions() != null ? getDeleteOptions(): item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public V1beta1EvictionFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public V1beta1EvictionFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public V1beta1EvictionFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public V1beta1EvictionFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public V1beta1EvictionFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1EvictionFluentImpl that = (V1beta1EvictionFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (deleteOptions != null ? !deleteOptions.equals(that.deleteOptions) :that.deleteOptions != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class DeleteOptionsNestedImpl<N> extends V1DeleteOptionsFluentImpl<V1beta1EvictionFluent.DeleteOptionsNested<N>> implements V1beta1EvictionFluent.DeleteOptionsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1DeleteOptionsBuilder builder;
    
            DeleteOptionsNestedImpl(V1DeleteOptions item){
                    this.builder = new V1DeleteOptionsBuilder(this, item);
            }
            DeleteOptionsNestedImpl(){
                    this.builder = new V1DeleteOptionsBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1EvictionFluentImpl.this.withDeleteOptions(builder.build());
    }
    public N endDeleteOptions(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<V1beta1EvictionFluent.MetadataNested<N>> implements V1beta1EvictionFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectMetaBuilder builder;
    
            MetadataNestedImpl(V1ObjectMeta item){
                    this.builder = new V1ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1EvictionFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
