package io.kubernetes.client.models;

import java.lang.Integer;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import java.lang.Long;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import org.joda.time.DateTime;
import java.util.LinkedHashMap;

public interface V1beta1PodDisruptionBudgetStatusFluent<A extends V1beta1PodDisruptionBudgetStatusFluent<A>> extends Fluent<A>{


    public Integer getCurrentHealthy();
    public A withCurrentHealthy(Integer currentHealthy);
    public Boolean hasCurrentHealthy();
    public A withNewCurrentHealthy(int arg1);
    public A withNewCurrentHealthy(String arg1);
    public Integer getDesiredHealthy();
    public A withDesiredHealthy(Integer desiredHealthy);
    public Boolean hasDesiredHealthy();
    public A withNewDesiredHealthy(int arg1);
    public A withNewDesiredHealthy(String arg1);
    public A addToDisruptedPods(String key,DateTime value);
    public A addToDisruptedPods(Map<String,DateTime> map);
    public A removeFromDisruptedPods(String key);
    public A removeFromDisruptedPods(Map<String,DateTime> map);
    public Map<String,DateTime> getDisruptedPods();
    public A withDisruptedPods(Map<String,DateTime> disruptedPods);
    public Boolean hasDisruptedPods();
    public Integer getDisruptionsAllowed();
    public A withDisruptionsAllowed(Integer disruptionsAllowed);
    public Boolean hasDisruptionsAllowed();
    public A withNewDisruptionsAllowed(int arg1);
    public A withNewDisruptionsAllowed(String arg1);
    public Integer getExpectedPods();
    public A withExpectedPods(Integer expectedPods);
    public Boolean hasExpectedPods();
    public A withNewExpectedPods(int arg1);
    public A withNewExpectedPods(String arg1);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public A withNewObservedGeneration(String arg1);
    public A withNewObservedGeneration(long arg1);



}
