package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import io.kubernetes.client.fluent.Predicate;

public interface V1beta1ResourceRuleFluent<A extends V1beta1ResourceRuleFluent<A>> extends Fluent<A>{


    public A addToApiGroups(int index,String item);
    public A setToApiGroups(int index,String item);
    public A addToApiGroups(String... items);
    public A addAllToApiGroups(Collection<String> items);
    public A removeFromApiGroups(String... items);
    public A removeAllFromApiGroups(Collection<String> items);
    public List<String> getApiGroups();
    public String getApiGroup(int index);
    public String getFirstApiGroup();
    public String getLastApiGroup();
    public String getMatchingApiGroup(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withApiGroups(List<String> apiGroups);
    public A withApiGroups(String... apiGroups);
    public Boolean hasApiGroups();
    public A addToResourceNames(int index,String item);
    public A setToResourceNames(int index,String item);
    public A addToResourceNames(String... items);
    public A addAllToResourceNames(Collection<String> items);
    public A removeFromResourceNames(String... items);
    public A removeAllFromResourceNames(Collection<String> items);
    public List<String> getResourceNames();
    public String getResourceName(int index);
    public String getFirstResourceName();
    public String getLastResourceName();
    public String getMatchingResourceName(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withResourceNames(List<String> resourceNames);
    public A withResourceNames(String... resourceNames);
    public Boolean hasResourceNames();
    public A addToResources(int index,String item);
    public A setToResources(int index,String item);
    public A addToResources(String... items);
    public A addAllToResources(Collection<String> items);
    public A removeFromResources(String... items);
    public A removeAllFromResources(Collection<String> items);
    public List<String> getResources();
    public String getResource(int index);
    public String getFirstResource();
    public String getLastResource();
    public String getMatchingResource(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withResources(List<String> resources);
    public A withResources(String... resources);
    public Boolean hasResources();
    public A addToVerbs(int index,String item);
    public A setToVerbs(int index,String item);
    public A addToVerbs(String... items);
    public A addAllToVerbs(Collection<String> items);
    public A removeFromVerbs(String... items);
    public A removeAllFromVerbs(Collection<String> items);
    public List<String> getVerbs();
    public String getVerb(int index);
    public String getFirstVerb();
    public String getLastVerb();
    public String getMatchingVerb(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withVerbs(List<String> verbs);
    public A withVerbs(String... verbs);
    public Boolean hasVerbs();



}
