package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1StatefulSetUpdateStrategyBuilder extends V1beta1StatefulSetUpdateStrategyFluentImpl<V1beta1StatefulSetUpdateStrategyBuilder> implements VisitableBuilder<V1beta1StatefulSetUpdateStrategy,V1beta1StatefulSetUpdateStrategyBuilder>{

    V1beta1StatefulSetUpdateStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1StatefulSetUpdateStrategyBuilder(){
            this(true);
    }
    public V1beta1StatefulSetUpdateStrategyBuilder(Boolean validationEnabled){
            this(new V1beta1StatefulSetUpdateStrategy(), validationEnabled);
    }
    public V1beta1StatefulSetUpdateStrategyBuilder(V1beta1StatefulSetUpdateStrategyFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1StatefulSetUpdateStrategyBuilder(V1beta1StatefulSetUpdateStrategyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1StatefulSetUpdateStrategy(), validationEnabled);
    }
    public V1beta1StatefulSetUpdateStrategyBuilder(V1beta1StatefulSetUpdateStrategyFluent<?> fluent,V1beta1StatefulSetUpdateStrategy instance){
            this(fluent, instance, true);
    }
    public V1beta1StatefulSetUpdateStrategyBuilder(V1beta1StatefulSetUpdateStrategyFluent<?> fluent,V1beta1StatefulSetUpdateStrategy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRollingUpdate(instance.getRollingUpdate());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1StatefulSetUpdateStrategyBuilder(V1beta1StatefulSetUpdateStrategy instance){
            this(instance,true);
    }
    public V1beta1StatefulSetUpdateStrategyBuilder(V1beta1StatefulSetUpdateStrategy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRollingUpdate(instance.getRollingUpdate());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1StatefulSetUpdateStrategy build(){
            V1beta1StatefulSetUpdateStrategy buildable = new V1beta1StatefulSetUpdateStrategy();
            buildable.setRollingUpdate(fluent.getRollingUpdate());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1StatefulSetUpdateStrategyBuilder that = (V1beta1StatefulSetUpdateStrategyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
