package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1WebhookClientConfigBuilder extends V1beta1WebhookClientConfigFluentImpl<V1beta1WebhookClientConfigBuilder> implements VisitableBuilder<V1beta1WebhookClientConfig,V1beta1WebhookClientConfigBuilder>{

    V1beta1WebhookClientConfigFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1WebhookClientConfigBuilder(){
            this(true);
    }
    public V1beta1WebhookClientConfigBuilder(Boolean validationEnabled){
            this(new V1beta1WebhookClientConfig(), validationEnabled);
    }
    public V1beta1WebhookClientConfigBuilder(V1beta1WebhookClientConfigFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1WebhookClientConfigBuilder(V1beta1WebhookClientConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1WebhookClientConfig(), validationEnabled);
    }
    public V1beta1WebhookClientConfigBuilder(V1beta1WebhookClientConfigFluent<?> fluent,V1beta1WebhookClientConfig instance){
            this(fluent, instance, true);
    }
    public V1beta1WebhookClientConfigBuilder(V1beta1WebhookClientConfigFluent<?> fluent,V1beta1WebhookClientConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCaBundle(instance.getCaBundle());

            fluent.withService(instance.getService());

            fluent.withUrl(instance.getUrl());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1WebhookClientConfigBuilder(V1beta1WebhookClientConfig instance){
            this(instance,true);
    }
    public V1beta1WebhookClientConfigBuilder(V1beta1WebhookClientConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCaBundle(instance.getCaBundle());

            this.withService(instance.getService());

            this.withUrl(instance.getUrl());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1WebhookClientConfig build(){
            V1beta1WebhookClientConfig buildable = new V1beta1WebhookClientConfig();
            buildable.setCaBundle(fluent.getCaBundle());
            buildable.setService(fluent.getService());
            buildable.setUrl(fluent.getUrl());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1WebhookClientConfigBuilder that = (V1beta1WebhookClientConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
