package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta2ControllerRevisionFluentImpl<A extends V1beta2ControllerRevisionFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta2ControllerRevisionFluent<A>{

    private String apiVersion;
    private RuntimeRawExtensionBuilder data;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private Long revision;

    public V1beta2ControllerRevisionFluentImpl(){
    }
    public V1beta2ControllerRevisionFluentImpl(V1beta2ControllerRevision instance){
            this.withApiVersion(instance.getApiVersion());

            this.withData(instance.getData());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withRevision(instance.getRevision());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    
/**
 * This method has been deprecated, please use method buildData instead.
 * @return The buildable object.
 */
@Deprecated public RuntimeRawExtension getData(){
            return this.data!=null?this.data.build():null;
    }

    public RuntimeRawExtension buildData(){
            return this.data!=null?this.data.build():null;
    }

    public A withData(RuntimeRawExtension data){
            _visitables.remove(this.data);
            if (data!=null){ this.data= new RuntimeRawExtensionBuilder(data); _visitables.add(this.data);} return (A) this;
    }

    public Boolean hasData(){
            return this.data != null;
    }

    public V1beta2ControllerRevisionFluent.DataNested<A> withNewData(){
            return new DataNestedImpl();
    }

    public V1beta2ControllerRevisionFluent.DataNested<A> withNewDataLike(RuntimeRawExtension item){
            return new DataNestedImpl(item);
    }

    public V1beta2ControllerRevisionFluent.DataNested<A> editData(){
            return withNewDataLike(getData());
    }

    public V1beta2ControllerRevisionFluent.DataNested<A> editOrNewData(){
            return withNewDataLike(getData() != null ? getData(): new RuntimeRawExtensionBuilder().build());
    }

    public V1beta2ControllerRevisionFluent.DataNested<A> editOrNewDataLike(RuntimeRawExtension item){
            return withNewDataLike(getData() != null ? getData(): item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public V1beta2ControllerRevisionFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public V1beta2ControllerRevisionFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public V1beta2ControllerRevisionFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public V1beta2ControllerRevisionFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public V1beta2ControllerRevisionFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public Long getRevision(){
            return this.revision;
    }

    public A withRevision(Long revision){
            this.revision=revision; return (A) this;
    }

    public Boolean hasRevision(){
            return this.revision != null;
    }

    public A withNewRevision(String arg1){
            return (A)withRevision(new Long(arg1));
    }

    public A withNewRevision(long arg1){
            return (A)withRevision(new Long(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2ControllerRevisionFluentImpl that = (V1beta2ControllerRevisionFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (data != null ? !data.equals(that.data) :that.data != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (revision != null ? !revision.equals(that.revision) :that.revision != null) return false;
            return true;
    }


    public class DataNestedImpl<N> extends RuntimeRawExtensionFluentImpl<V1beta2ControllerRevisionFluent.DataNested<N>> implements V1beta2ControllerRevisionFluent.DataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final RuntimeRawExtensionBuilder builder;
    
            DataNestedImpl(RuntimeRawExtension item){
                    this.builder = new RuntimeRawExtensionBuilder(this, item);
            }
            DataNestedImpl(){
                    this.builder = new RuntimeRawExtensionBuilder(this);
            }
    
    public N and(){
            return (N) V1beta2ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endData(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<V1beta2ControllerRevisionFluent.MetadataNested<N>> implements V1beta2ControllerRevisionFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectMetaBuilder builder;
    
            MetadataNestedImpl(V1ObjectMeta item){
                    this.builder = new V1ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) V1beta2ControllerRevisionFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
