package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta2DeploymentStatusBuilder extends V1beta2DeploymentStatusFluentImpl<V1beta2DeploymentStatusBuilder> implements VisitableBuilder<V1beta2DeploymentStatus,V1beta2DeploymentStatusBuilder>{

    V1beta2DeploymentStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta2DeploymentStatusBuilder(){
            this(true);
    }
    public V1beta2DeploymentStatusBuilder(Boolean validationEnabled){
            this(new V1beta2DeploymentStatus(), validationEnabled);
    }
    public V1beta2DeploymentStatusBuilder(V1beta2DeploymentStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta2DeploymentStatusBuilder(V1beta2DeploymentStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta2DeploymentStatus(), validationEnabled);
    }
    public V1beta2DeploymentStatusBuilder(V1beta2DeploymentStatusFluent<?> fluent,V1beta2DeploymentStatus instance){
            this(fluent, instance, true);
    }
    public V1beta2DeploymentStatusBuilder(V1beta2DeploymentStatusFluent<?> fluent,V1beta2DeploymentStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAvailableReplicas(instance.getAvailableReplicas());

            fluent.withCollisionCount(instance.getCollisionCount());

            fluent.withConditions(instance.getConditions());

            fluent.withObservedGeneration(instance.getObservedGeneration());

            fluent.withReadyReplicas(instance.getReadyReplicas());

            fluent.withReplicas(instance.getReplicas());

            fluent.withUnavailableReplicas(instance.getUnavailableReplicas());

            fluent.withUpdatedReplicas(instance.getUpdatedReplicas());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta2DeploymentStatusBuilder(V1beta2DeploymentStatus instance){
            this(instance,true);
    }
    public V1beta2DeploymentStatusBuilder(V1beta2DeploymentStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAvailableReplicas(instance.getAvailableReplicas());

            this.withCollisionCount(instance.getCollisionCount());

            this.withConditions(instance.getConditions());

            this.withObservedGeneration(instance.getObservedGeneration());

            this.withReadyReplicas(instance.getReadyReplicas());

            this.withReplicas(instance.getReplicas());

            this.withUnavailableReplicas(instance.getUnavailableReplicas());

            this.withUpdatedReplicas(instance.getUpdatedReplicas());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta2DeploymentStatus build(){
            V1beta2DeploymentStatus buildable = new V1beta2DeploymentStatus();
            buildable.setAvailableReplicas(fluent.getAvailableReplicas());
            buildable.setCollisionCount(fluent.getCollisionCount());
            buildable.setConditions(fluent.getConditions());
            buildable.setObservedGeneration(fluent.getObservedGeneration());
            buildable.setReadyReplicas(fluent.getReadyReplicas());
            buildable.setReplicas(fluent.getReplicas());
            buildable.setUnavailableReplicas(fluent.getUnavailableReplicas());
            buildable.setUpdatedReplicas(fluent.getUpdatedReplicas());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2DeploymentStatusBuilder that = (V1beta2DeploymentStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
