package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface V1beta2StatefulSetFluent<A extends V1beta2StatefulSetFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata();
    public V1ObjectMeta buildMetadata();
    public A withMetadata(V1ObjectMeta metadata);
    public Boolean hasMetadata();
    public V1beta2StatefulSetFluent.MetadataNested<A> withNewMetadata();
    public V1beta2StatefulSetFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item);
    public V1beta2StatefulSetFluent.MetadataNested<A> editMetadata();
    public V1beta2StatefulSetFluent.MetadataNested<A> editOrNewMetadata();
    public V1beta2StatefulSetFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public V1beta2StatefulSetSpec getSpec();
    public V1beta2StatefulSetSpec buildSpec();
    public A withSpec(V1beta2StatefulSetSpec spec);
    public Boolean hasSpec();
    public V1beta2StatefulSetFluent.SpecNested<A> withNewSpec();
    public V1beta2StatefulSetFluent.SpecNested<A> withNewSpecLike(V1beta2StatefulSetSpec item);
    public V1beta2StatefulSetFluent.SpecNested<A> editSpec();
    public V1beta2StatefulSetFluent.SpecNested<A> editOrNewSpec();
    public V1beta2StatefulSetFluent.SpecNested<A> editOrNewSpecLike(V1beta2StatefulSetSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public V1beta2StatefulSetStatus getStatus();
    public V1beta2StatefulSetStatus buildStatus();
    public A withStatus(V1beta2StatefulSetStatus status);
    public Boolean hasStatus();
    public V1beta2StatefulSetFluent.StatusNested<A> withNewStatus();
    public V1beta2StatefulSetFluent.StatusNested<A> withNewStatusLike(V1beta2StatefulSetStatus item);
    public V1beta2StatefulSetFluent.StatusNested<A> editStatus();
    public V1beta2StatefulSetFluent.StatusNested<A> editOrNewStatus();
    public V1beta2StatefulSetFluent.StatusNested<A> editOrNewStatusLike(V1beta2StatefulSetStatus item);

    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectMetaFluent<V1beta2StatefulSetFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1beta2StatefulSetSpecFluent<V1beta2StatefulSetFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1beta2StatefulSetStatusFluent<V1beta2StatefulSetFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
