package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V2beta1ObjectMetricSourceFluentImpl<A extends V2beta1ObjectMetricSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V2beta1ObjectMetricSourceFluent<A>{

    private String metricName;
    private V2beta1CrossVersionObjectReferenceBuilder target;
    private String targetValue;

    public V2beta1ObjectMetricSourceFluentImpl(){
    }
    public V2beta1ObjectMetricSourceFluentImpl(V2beta1ObjectMetricSource instance){
            this.withMetricName(instance.getMetricName());

            this.withTarget(instance.getTarget());

            this.withTargetValue(instance.getTargetValue());

    }

    public String getMetricName(){
            return this.metricName;
    }

    public A withMetricName(String metricName){
            this.metricName=metricName; return (A) this;
    }

    public Boolean hasMetricName(){
            return this.metricName != null;
    }

    
/**
 * This method has been deprecated, please use method buildTarget instead.
 * @return The buildable object.
 */
@Deprecated public V2beta1CrossVersionObjectReference getTarget(){
            return this.target!=null?this.target.build():null;
    }

    public V2beta1CrossVersionObjectReference buildTarget(){
            return this.target!=null?this.target.build():null;
    }

    public A withTarget(V2beta1CrossVersionObjectReference target){
            _visitables.remove(this.target);
            if (target!=null){ this.target= new V2beta1CrossVersionObjectReferenceBuilder(target); _visitables.add(this.target);} return (A) this;
    }

    public Boolean hasTarget(){
            return this.target != null;
    }

    public V2beta1ObjectMetricSourceFluent.TargetNested<A> withNewTarget(){
            return new TargetNestedImpl();
    }

    public V2beta1ObjectMetricSourceFluent.TargetNested<A> withNewTargetLike(V2beta1CrossVersionObjectReference item){
            return new TargetNestedImpl(item);
    }

    public V2beta1ObjectMetricSourceFluent.TargetNested<A> editTarget(){
            return withNewTargetLike(getTarget());
    }

    public V2beta1ObjectMetricSourceFluent.TargetNested<A> editOrNewTarget(){
            return withNewTargetLike(getTarget() != null ? getTarget(): new V2beta1CrossVersionObjectReferenceBuilder().build());
    }

    public V2beta1ObjectMetricSourceFluent.TargetNested<A> editOrNewTargetLike(V2beta1CrossVersionObjectReference item){
            return withNewTargetLike(getTarget() != null ? getTarget(): item);
    }

    public String getTargetValue(){
            return this.targetValue;
    }

    public A withTargetValue(String targetValue){
            this.targetValue=targetValue; return (A) this;
    }

    public Boolean hasTargetValue(){
            return this.targetValue != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2beta1ObjectMetricSourceFluentImpl that = (V2beta1ObjectMetricSourceFluentImpl) o;
            if (metricName != null ? !metricName.equals(that.metricName) :that.metricName != null) return false;
            if (target != null ? !target.equals(that.target) :that.target != null) return false;
            if (targetValue != null ? !targetValue.equals(that.targetValue) :that.targetValue != null) return false;
            return true;
    }


    public class TargetNestedImpl<N> extends V2beta1CrossVersionObjectReferenceFluentImpl<V2beta1ObjectMetricSourceFluent.TargetNested<N>> implements V2beta1ObjectMetricSourceFluent.TargetNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V2beta1CrossVersionObjectReferenceBuilder builder;
    
            TargetNestedImpl(V2beta1CrossVersionObjectReference item){
                    this.builder = new V2beta1CrossVersionObjectReferenceBuilder(this, item);
            }
            TargetNestedImpl(){
                    this.builder = new V2beta1CrossVersionObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) V2beta1ObjectMetricSourceFluentImpl.this.withTarget(builder.build());
    }
    public N endTarget(){
            return and();
    }

}


}
