/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.statsd.StatsdFlavor;
import java.time.Duration;

public interface StatsdConfig
extends MeterRegistryConfig {
    public static final StatsdConfig DEFAULT = k -> null;

    default public String prefix() {
        return "statsd";
    }

    default public StatsdFlavor flavor() {
        String v = this.get(this.prefix() + ".flavor");
        if (v == null) {
            return StatsdFlavor.Datadog;
        }
        for (StatsdFlavor flavor : StatsdFlavor.values()) {
            if (!flavor.toString().equalsIgnoreCase(v)) continue;
            return flavor;
        }
        throw new IllegalArgumentException("Unrecognized statsd flavor '" + v + "' (check property " + this.prefix() + ".flavor)");
    }

    default public boolean enabled() {
        String v = this.get(this.prefix() + ".enabled");
        return v == null || Boolean.valueOf(v) != false;
    }

    default public String host() {
        String v = this.get(this.prefix() + ".host");
        return v == null ? "localhost" : v;
    }

    default public int port() {
        String v = this.get(this.prefix() + ".port");
        return v == null ? 8125 : Integer.parseInt(v);
    }

    default public int maxPacketLength() {
        String v = this.get(this.prefix() + ".maxPacketLength");
        return v == null ? 1400 : Integer.parseInt(v);
    }

    default public Duration pollingFrequency() {
        String v = this.get(this.prefix() + ".pollingFrequency");
        return v == null ? Duration.ofSeconds(10L) : Duration.parse(v);
    }

    default public int queueSize() {
        String v = this.get(this.prefix() + ".queueSize");
        return v == null ? Integer.MAX_VALUE : Integer.parseInt(v);
    }

    default public Duration step() {
        String v = this.get(this.prefix() + ".step");
        return v == null ? Duration.ofSeconds(10L) : Duration.parse(v);
    }
}

