/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd.internal;

import java.util.function.Function;

public class MemoizingSupplier<T, R>
implements Function<T, R> {
    private final Function<T, R> delegate;
    private volatile transient boolean initialized;
    private volatile transient T lastInput;
    private transient R value;

    public MemoizingSupplier(Function<T, R> delegate) {
        this.delegate = delegate;
    }

    public static <U, V> MemoizingSupplier<U, V> memoize(Function<U, V> delegate) {
        return new MemoizingSupplier<U, V>(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R apply(T t) {
        if (!this.initialized || t != this.lastInput) {
            MemoizingSupplier memoizingSupplier = this;
            synchronized (memoizingSupplier) {
                if (!this.initialized || t != this.lastInput) {
                    this.lastInput = t;
                    R r = this.delegate.apply(t);
                    this.value = r;
                    this.initialized = true;
                    return r;
                }
            }
        }
        return this.value;
    }

    public String toString() {
        return "Suppliers.memoize(" + this.delegate + ")";
    }
}

