/*
 * Copyright 2017-2020 original authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.micronaut.session;

import io.micronaut.context.annotation.Primary;

import javax.inject.Singleton;
import java.util.UUID;

/**
 * Default session ID generator that uses {@link UUID}.
 *
 * @author Graeme Rocher
 * @since 1.0
 */
@Singleton
@Primary
public class DefaultSessionIdGenerator implements SessionIdGenerator {

    @Override
    public String generateId() {
        return UUID.randomUUID().toString();
    }
}
