/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;

public final class NUID {
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final int base = 62;
    static final int preLen = 12;
    static final int seqLen = 10;
    static final long maxSeq = 839299365868340224L;
    static final long minInc = 33L;
    static final long maxInc = 333L;
    static final int totalLen = 22;
    private SecureRandom srand;
    private final Random prand;
    char[] pre;
    private long seq;
    private long inc;
    public static final NUID globalNUID = new NUID();

    static NUID getInstance() {
        return globalNUID;
    }

    public NUID() {
        long seed = 0L;
        try {
            this.srand = SecureRandom.getInstance("SHA1PRNG");
            seed = NUID.bytesToLong(this.srand.generateSeed(8));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        this.prand = seed != 0L ? new Random(seed) : new Random();
        this.seq = NUID.nextLong(this.prand, 839299365868340224L);
        this.inc = 33L + NUID.nextLong(this.prand, 300L);
        this.pre = new char[12];
        for (int i = 0; i < 12; ++i) {
            this.pre[i] = 48;
        }
        this.randomizePrefix();
    }

    public static synchronized String nextGlobal() {
        return NUID.getInstance().next();
    }

    public final String next() {
        this.seq += this.inc;
        if (this.seq >= 839299365868340224L) {
            this.randomizePrefix();
            this.resetSequential();
        }
        char[] b = new char[22];
        System.arraycopy(this.pre, 0, b, 0, 12);
        int i = b.length;
        long l = this.seq;
        while (i > 12) {
            b[--i] = digits[(int)(l % 62L)];
            l /= 62L;
        }
        return new String(b);
    }

    void resetSequential() {
        this.seq = NUID.nextLong(this.prand, 839299365868340224L);
        this.inc = 33L + NUID.nextLong(this.prand, 300L);
    }

    final void randomizePrefix() {
        byte[] cb = new byte[12];
        this.srand.nextBytes(cb);
        for (int i = 0; i < 12; ++i) {
            this.pre[i] = digits[(cb[i] & 0xFF) % 62];
        }
    }

    static long nextLong(Random rng, long maxValue) {
        long val;
        long bits;
        while ((bits = rng.nextLong() << 1 >>> 1) - (val = bits % maxValue) + (maxValue - 1L) < 0L) {
        }
        return val;
    }

    static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(64);
        buffer.putLong(x);
        return buffer.array();
    }

    static long bytesToLong(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(64);
        buffer.put(bytes);
        buffer.flip();
        return buffer.getLong();
    }

    char[] getPre() {
        return this.pre;
    }

    void setPre(char[] pre) {
        this.pre = Arrays.copyOf(pre, pre.length);
    }

    long getSeq() {
        return this.seq;
    }

    void setSeq(long seq) {
        this.seq = seq;
    }

    long getInc() {
        return this.inc;
    }

    void setInc(long inc) {
        this.inc = inc;
    }
}

