/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.TransportConnection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class TcpConnection
implements TransportConnection,
AutoCloseable {
    private final ReentrantLock mu = new ReentrantLock();
    private SocketFactory factory = SocketFactory.getDefault();
    private SSLContext sslContext;
    private Socket client = null;
    private OutputStream writeStream = null;
    private InputStream readStream = null;
    private BufferedReader bisr = null;
    private BufferedInputStream bis = null;
    private BufferedOutputStream bos = null;
    private int timeout = 0;

    TcpConnection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(String url, int timeout) throws IOException {
        URI uri = URI.create(url);
        String host = uri.getHost();
        int port = uri.getPort();
        this.mu.lock();
        try {
            this.client = this.factory.createSocket();
            this.client.setTcpNoDelay(true);
            this.client.setReceiveBufferSize(0x200000);
            this.client.setSendBufferSize(0x200000);
            this.client.connect(new InetSocketAddress(host, port), timeout);
            this.writeStream = this.client.getOutputStream();
            this.readStream = this.client.getInputStream();
        }
        finally {
            this.mu.unlock();
        }
    }

    void setConnectTimeout(int value) {
        this.timeout = value;
    }

    boolean isSetup() {
        return this.client != null;
    }

    void teardown() {
        this.mu.lock();
        try {
            if (this.client != null) {
                this.client.close();
            }
            this.client = null;
            this.writeStream = null;
            this.readStream = null;
            this.bisr = null;
            this.bis = null;
            this.bos = null;
        }
        catch (IOException iOException) {
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public BufferedReader getBufferedReader() {
        return new BufferedReader(new InputStreamReader(this.bis));
    }

    @Override
    public InputStream getInputStream(int size) {
        if (this.bis == null) {
            this.bis = size > 0 ? new BufferedInputStream(this.readStream, size) : new BufferedInputStream(this.readStream);
            this.bis = new BufferedInputStream(this.readStream, size);
        }
        return this.bis;
    }

    @Override
    public OutputStream getOutputStream(int size) {
        if (this.bos == null) {
            this.bos = new BufferedOutputStream(this.writeStream, size);
        }
        return this.bos;
    }

    @Override
    public boolean isConnected() {
        return this.client != null && this.client.isConnected();
    }

    @Override
    public boolean isClosed() {
        return this.client.isClosed();
    }

    void setSocketFactory(SocketFactory factory) {
        this.factory = factory;
    }

    protected SSLSocketFactory getSslSocketFactory() {
        if (this.factory instanceof SSLSocketFactory) {
            return (SSLSocketFactory)this.factory;
        }
        return null;
    }

    void makeTls(SSLContext context) throws IOException {
        this.sslContext = context;
        this.setSocketFactory(this.sslContext.getSocketFactory());
        this.makeTls();
    }

    void makeTls() throws IOException {
        SSLSocketFactory sslSf = this.getSslSocketFactory();
        SSLSocket sslSocket = (SSLSocket)sslSf.createSocket(this.client, this.client.getInetAddress().getHostAddress(), this.client.getPort(), true);
        sslSocket.startHandshake();
        this.bisr = null;
        this.readStream = sslSocket.getInputStream();
        this.bis = null;
        this.writeStream = sslSocket.getOutputStream();
        this.bos = null;
    }

    void setSocket(Socket sock) {
        this.mu.lock();
        try {
            this.client = sock;
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.teardown();
    }

    protected SSLContext getSslContext() {
        return this.sslContext;
    }

    protected void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    protected void setReadStream(InputStream in) {
        this.readStream = in;
    }

    protected InputStream getReadStream() {
        return this.readStream;
    }

    protected void setWriteStream(OutputStream out) {
        this.writeStream = out;
    }

    protected OutputStream getWriteStream() {
        return this.writeStream;
    }

    protected int getTimeout() {
        return this.timeout;
    }
}

