/*
 * Decompiled with CFR 0.152.
 */
package io.nats.streaming.examples;

import io.nats.streaming.AckHandler;
import io.nats.streaming.NatsStreaming;
import io.nats.streaming.Options;
import io.nats.streaming.StreamingConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;

public class Publisher {
    private String urls;
    private String subject;
    private String payloadString;
    private String clusterId = "test-cluster";
    private String clientId = "test-client";
    private boolean async;
    private static final String usageString = "\nUsage: java Publisher [options] <subject> <message>\n\nOptions:\n    -s, --server   <urls>           NATS Streaming server URL(s)\n    -c, --cluster  <cluster name>   NATS Streaming cluster name\n    -id,--clientid <client ID>      NATS Streaming client ID\n    -a, --async                     Asynchronous publish mode";

    public Publisher(String[] args) {
        this.parseArgs(args);
    }

    private static void usage() {
        System.err.println(usageString);
    }

    public void run() throws Exception {
        block21: {
            Options opts = NatsStreaming.defaultOptions();
            if (this.urls != null) {
                opts = new Options.Builder().natsUrl(this.urls).build();
            }
            try (StreamingConnection sc = NatsStreaming.connect((String)this.clusterId, (String)this.clientId, (Options)opts);){
                final CountDownLatch latch = new CountDownLatch(1);
                final String[] guid = new String[1];
                byte[] payload = this.payloadString.getBytes();
                AckHandler acb = new AckHandler(){

                    public void onAck(String nuid, Exception ex) {
                        System.out.printf("Received ACK for guid %s\n", nuid);
                        if (ex != null) {
                            System.err.printf("Error in server ack for guid %s: %s", nuid, ex.getMessage());
                        }
                        if (!guid[0].equals(nuid)) {
                            System.err.printf("Expected a matching guid in ack callback, got %s vs %s\n", nuid, guid[0]);
                        }
                        System.out.flush();
                        latch.countDown();
                    }
                };
                if (!this.async) {
                    try {
                        sc.publish(this.subject, payload);
                    }
                    catch (Exception e) {
                        System.err.printf("Error during publish: %s\n", e.getMessage());
                        throw e;
                    }
                    System.out.printf("Published [%s] : '%s'\n", this.subject, this.payloadString);
                    break block21;
                }
                try {
                    guid[0] = sc.publish(this.subject, payload, acb);
                    latch.await();
                }
                catch (IOException e) {
                    System.err.printf("Error during async publish: %s\n", e.getMessage());
                    throw e;
                }
                if (guid[0].isEmpty()) {
                    String msg = "Expected non-empty guid to be returned.";
                    System.err.println(msg);
                    throw new IOException(msg);
                }
                System.out.printf("Published [%s] : '%s' [guid: %s]\n", this.subject, this.payloadString, guid[0]);
            }
        }
    }

    private void parseArgs(String[] args) {
        if (args == null || args.length < 2) {
            throw new IllegalArgumentException("must supply at least subject and msg");
        }
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        this.payloadString = (String)argList.remove(argList.size() - 1);
        this.subject = (String)argList.remove(argList.size() - 1);
        Iterator it = argList.iterator();
        block16: while (it.hasNext()) {
            String arg;
            switch (arg = (String)it.next()) {
                case "-s": 
                case "--server": {
                    if (!it.hasNext()) {
                        throw new IllegalArgumentException(arg + " requires an argument");
                    }
                    it.remove();
                    this.urls = (String)it.next();
                    it.remove();
                    continue block16;
                }
                case "-c": 
                case "--cluster": {
                    if (!it.hasNext()) {
                        throw new IllegalArgumentException(arg + " requires an argument");
                    }
                    it.remove();
                    this.clusterId = (String)it.next();
                    it.remove();
                    continue block16;
                }
                case "-id": 
                case "--clientid": {
                    if (!it.hasNext()) {
                        throw new IllegalArgumentException(arg + " requires an argument");
                    }
                    it.remove();
                    this.clientId = (String)it.next();
                    it.remove();
                    continue block16;
                }
                case "-a": 
                case "--async": {
                    this.async = true;
                    it.remove();
                    continue block16;
                }
            }
            throw new IllegalArgumentException(String.format("Unexpected token: '%s'", arg));
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            new Publisher(args).run();
        }
        catch (IllegalArgumentException e) {
            System.out.flush();
            System.err.println(e.getMessage());
            Publisher.usage();
            System.err.flush();
            throw e;
        }
    }
}

