/*
 * Decompiled with CFR 0.152.
 */
package io.nats.streaming.examples;

import io.nats.streaming.Message;
import io.nats.streaming.MessageHandler;
import io.nats.streaming.NatsStreaming;
import io.nats.streaming.Options;
import io.nats.streaming.StreamingConnection;
import io.nats.streaming.Subscription;
import io.nats.streaming.SubscriptionOptions;
import java.text.ParseException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Subscriber {
    private String url;
    private String subject;
    private String clusterId = "test-cluster";
    private String clientId = "test-client";
    private final SubscriptionOptions.Builder builder = new SubscriptionOptions.Builder();
    private String qgroup;
    private String durable;
    private int count = 0;
    private boolean unsubscribe;
    private static final String usageString = "\nUsage: java Subscriber [options] <subject>\n\nOptions:\n    -s,  --server   <urls>           NATS Streaming server URL(s)\n    -c,  --cluster  <cluster name>   NATS Streaming cluster name\n    -id, --clientid <client ID>      NATS Streaming client ID               \n\nSubscription Options:                                             \n     -q, --qgroup   <name>           Queue group\n         --seq      <seqno>          Start at seqno\n         --all                       Deliver all available messages\n         --last                      Deliver starting with last published message\n         --since    <duration>       Deliver messages in last interval (e.g. 1s, 1hr)\n                   (format: 00d00h00m00s00ns)\n         --durable  <name>           Durable subscriber name\n         --unsubscribe               Unsubscribe the durable on exit\n         --count    <num>            Number of messages to receive";
    private static final Pattern pattern = Pattern.compile("(\\d+)d\\s*(\\d+)h\\s*(\\d+)m\\s*(\\d+)s\\s*(\\d+)ns");

    public Subscriber(String[] args) {
        this.parseArgs(args);
    }

    private static void usage() {
        System.err.println(usageString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws Exception {
        Options opts = null;
        if (this.url != null) {
            opts = new Options.Builder().natsUrl(this.url).build();
        }
        final CountDownLatch done = new CountDownLatch(1);
        final CountDownLatch start = new CountDownLatch(1);
        final AtomicInteger delivered = new AtomicInteger(0);
        Thread hook = null;
        try (final StreamingConnection sc = NatsStreaming.connect((String)this.clusterId, (String)this.clientId, (Options)opts);){
            try {
                final Subscription sub = sc.subscribe(this.subject, this.qgroup, new MessageHandler(){

                    public void onMessage(Message msg) {
                        try {
                            start.await();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        System.out.printf("[#%d] Received on [%s]: '%s'\n", delivered.incrementAndGet(), msg.getSubject(), msg);
                        if (delivered.get() == Subscriber.this.count) {
                            done.countDown();
                        }
                    }
                }, this.builder.build());
                hook = new Thread(){

                    @Override
                    public void run() {
                        System.err.println("\nCaught CTRL-C, shutting down gracefully...\n");
                        try {
                            if (Subscriber.this.durable == null || Subscriber.this.durable.isEmpty() || Subscriber.this.unsubscribe) {
                                sub.unsubscribe();
                            }
                            sc.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        done.countDown();
                    }
                };
                Runtime.getRuntime().addShutdownHook(hook);
                System.out.printf("Listening on [%s], clientID=[%s], qgroup=[%s] durable=[%s]\n", sub.getSubject(), this.clientId, sub.getQueue(), sub.getOptions().getDurableName());
                start.countDown();
                done.await();
                if (this.durable == null || this.durable.isEmpty() || this.unsubscribe) {
                    sub.unsubscribe();
                }
                sc.close();
                Runtime.getRuntime().removeShutdownHook(hook);
            }
            catch (Throwable throwable) {
                Runtime.getRuntime().removeShutdownHook(hook);
                throw throwable;
            }
        }
    }

    private void parseArgs(String[] args) {
        if (args == null || args.length < 1) {
            throw new IllegalArgumentException("must supply at least a subject name");
        }
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        this.subject = (String)argList.remove(argList.size() - 1);
        Iterator it = argList.iterator();
        block33: while (it.hasNext()) {
            String arg;
            switch (arg = (String)it.next()) {
                case "-s": 
                case "--server": {
                    if (!it.hasNext()) {
                        throw new IllegalArgumentException(arg + " requires an argument");
                    }
                    it.remove();
                    this.url = (String)it.next();
                    it.remove();
                    continue block33;
                }
                case "-c": 
                case "--cluster": {
                    if (!it.hasNext()) {
                        throw new IllegalArgumentException(arg + " requires an argument");
                    }
                    it.remove();
                    this.clusterId = (String)it.next();
                    it.remove();
                    continue block33;
                }
                case "-id": 
                case "--clientid": {
                    if (!it.hasNext()) {
                        throw new IllegalArgumentException(arg + " requires an argument");
                    }
                    it.remove();
                    this.clientId = (String)it.next();
                    it.remove();
                    continue block33;
                }
                case "-q": 
                case "--qgroup": {
                    if (!it.hasNext()) {
                        throw new IllegalArgumentException(arg + " requires an argument");
                    }
                    it.remove();
                    this.qgroup = (String)it.next();
                    it.remove();
                    continue block33;
                }
                case "--seq": {
                    if (!it.hasNext()) {
                        throw new IllegalArgumentException(arg + " requires an argument");
                    }
                    it.remove();
                    this.builder.startAtSequence(Long.parseLong((String)it.next()));
                    it.remove();
                    continue block33;
                }
                case "--all": {
                    this.builder.deliverAllAvailable();
                    it.remove();
                    continue block33;
                }
                case "--last": {
                    this.builder.startWithLastReceived();
                    it.remove();
                    continue block33;
                }
                case "--since": {
                    if (!it.hasNext()) {
                        throw new IllegalArgumentException(arg + " requires an argument");
                    }
                    it.remove();
                    try {
                        this.builder.startAtTimeDelta(Subscriber.parseDuration((String)it.next()));
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException(e.getMessage());
                    }
                    it.remove();
                    continue block33;
                }
                case "--durable": {
                    if (!it.hasNext()) {
                        throw new IllegalArgumentException(arg + " requires an argument");
                    }
                    it.remove();
                    this.builder.durableName((String)it.next());
                    it.remove();
                    continue block33;
                }
                case "-u": 
                case "--unsubscribe": {
                    this.unsubscribe = true;
                    it.remove();
                    continue block33;
                }
                case "--count": {
                    if (!it.hasNext()) {
                        throw new IllegalArgumentException(arg + " requires an argument");
                    }
                    it.remove();
                    this.count = Integer.parseInt((String)it.next());
                    it.remove();
                    continue block33;
                }
            }
            throw new IllegalArgumentException(String.format("Unexpected token: '%s'", arg));
        }
    }

    private static Duration parseDuration(String duration) throws ParseException {
        Matcher matcher = pattern.matcher(duration);
        long nanoseconds = 0L;
        if (matcher.find() && matcher.groupCount() == 4) {
            int days = Integer.parseInt(matcher.group(1));
            nanoseconds += TimeUnit.NANOSECONDS.convert(days, TimeUnit.DAYS);
            int hours = Integer.parseInt(matcher.group(2));
            nanoseconds += TimeUnit.NANOSECONDS.convert(hours, TimeUnit.HOURS);
            int minutes = Integer.parseInt(matcher.group(3));
            nanoseconds += TimeUnit.NANOSECONDS.convert(minutes, TimeUnit.MINUTES);
            int seconds = Integer.parseInt(matcher.group(4));
            nanoseconds += TimeUnit.NANOSECONDS.convert(seconds, TimeUnit.SECONDS);
        } else {
            throw new ParseException("Cannot parse duration " + duration, 0);
        }
        long nanos = Long.parseLong(matcher.group(5));
        return Duration.ofNanos(nanoseconds += nanos);
    }

    public static void main(String[] args) throws Exception {
        try {
            new Subscriber(args).run();
        }
        catch (IllegalArgumentException e) {
            System.out.flush();
            System.err.println(e.getMessage());
            Subscriber.usage();
            System.err.flush();
            throw e;
        }
    }
}

