/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.http.util;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedInts;
import com.google.common.primitives.UnsignedLongs;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.TraceId;
import io.opencensus.trace.TraceOptions;
import io.opencensus.trace.propagation.SpanContextParseException;
import io.opencensus.trace.propagation.TextFormat;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;

final class CloudTraceFormat
extends TextFormat {
    static final String HEADER_NAME = "X-Cloud-Trace-Context";
    static final List<String> FIELDS = Collections.singletonList("X-Cloud-Trace-Context");
    static final char SPAN_ID_DELIMITER = '/';
    static final String TRACE_OPTION_DELIMITER = ";o=";
    static final String SAMPLED = "1";
    static final String NOT_SAMPLED = "0";
    static final TraceOptions OPTIONS_SAMPLED = TraceOptions.builder().setIsSampled(true).build();
    static final TraceOptions OPTIONS_NOT_SAMPLED = TraceOptions.DEFAULT;
    static final int TRACE_ID_SIZE = 32;
    static final int TRACE_OPTION_DELIMITER_SIZE = ";o=".length();
    static final int SPAN_ID_START_POS = 33;
    static final int MIN_HEADER_SIZE = 34;
    static final int CLOUD_TRACE_IS_SAMPLED = 1;

    CloudTraceFormat() {
    }

    public List<String> fields() {
        return FIELDS;
    }

    public <C> void inject(SpanContext spanContext, C carrier, TextFormat.Setter<C> setter) {
        Preconditions.checkNotNull((Object)spanContext, (Object)"spanContext");
        Preconditions.checkNotNull(setter, (Object)"setter");
        Preconditions.checkNotNull(carrier, (Object)"carrier");
        StringBuilder builder = new StringBuilder().append(spanContext.getTraceId().toLowerBase16()).append('/').append(UnsignedLongs.toString((long)CloudTraceFormat.spanIdToLong(spanContext.getSpanId()))).append(TRACE_OPTION_DELIMITER).append(spanContext.getTraceOptions().isSampled() ? SAMPLED : NOT_SAMPLED);
        setter.put(carrier, HEADER_NAME, builder.toString());
    }

    public <C> SpanContext extract(C carrier, TextFormat.Getter<C> getter) throws SpanContextParseException {
        Preconditions.checkNotNull(carrier, (Object)"carrier");
        Preconditions.checkNotNull(getter, (Object)"getter");
        try {
            String traceOptionsStr;
            String headerStr = getter.get(carrier, HEADER_NAME);
            if (headerStr == null || headerStr.length() < 34) {
                throw new SpanContextParseException("Missing or too short header: X-Cloud-Trace-Context");
            }
            Preconditions.checkArgument((headerStr.charAt(32) == '/' ? 1 : 0) != 0, (Object)"Invalid TRACE_ID size");
            TraceId traceId = TraceId.fromLowerBase16((CharSequence)headerStr.subSequence(0, 32));
            int traceOptionsPos = headerStr.indexOf(TRACE_OPTION_DELIMITER, 32);
            CharSequence spanIdStr = headerStr.subSequence(33, traceOptionsPos < 0 ? headerStr.length() : traceOptionsPos);
            SpanId spanId = CloudTraceFormat.longToSpanId(UnsignedLongs.parseUnsignedLong((String)spanIdStr.toString(), (int)10));
            TraceOptions traceOptions = OPTIONS_NOT_SAMPLED;
            if (traceOptionsPos > 0 && (UnsignedInts.parseUnsignedInt((String)(traceOptionsStr = headerStr.substring(traceOptionsPos + TRACE_OPTION_DELIMITER_SIZE)), (int)10) & 1) != 0) {
                traceOptions = OPTIONS_SAMPLED;
            }
            return SpanContext.create((TraceId)traceId, (SpanId)spanId, (TraceOptions)traceOptions);
        }
        catch (IllegalArgumentException e) {
            throw new SpanContextParseException("Invalid input", (Throwable)e);
        }
    }

    private static SpanId longToSpanId(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return SpanId.fromBytes((byte[])buffer.array());
    }

    private static long spanIdToLong(SpanId spanId) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(spanId.getBytes());
        return buffer.getLong(0);
    }
}

