/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.jdbc;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.jdbc.JdbcUrlCreator;

public abstract class AbstractJdbcUrlCreator
implements JdbcUrlCreator {
    public static final String JDBC_PREFIX = "jdbc:";

    protected boolean jdbcUrlMatchesScheme(CfService cfService, String ... uriSchemes) {
        CfCredentials cfCredentials = cfService.getCredentials();
        String jdbcUrl = (String)cfCredentials.getMap().get("jdbcUrl");
        if (jdbcUrl != null) {
            for (String uriScheme : uriSchemes) {
                if (!jdbcUrl.startsWith(JDBC_PREFIX + uriScheme + ":")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String createJdbcUrl(CfService cfService) {
        CfCredentials cfCredentials = cfService.getCredentials();
        String jdbcUrl = (String)cfCredentials.getMap().get("jdbcUrl");
        if (jdbcUrl != null) {
            return jdbcUrl;
        }
        return this.buildJdbcUrlFromUriField(cfCredentials);
    }

    public abstract String buildJdbcUrlFromUriField(CfCredentials var1);
}

