/*
 * Decompiled with CFR 0.152.
 */
package io.pleo.prop.guice.internal;

import com.google.inject.ConfigurationException;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.ProvidesMethodBinding;
import com.google.inject.spi.ProvidesMethodTargetVisitor;
import com.google.inject.spi.UntargettedBinding;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectionPointExtractor
extends DefaultBindingTargetVisitor<Object, InjectionPoint>
implements ProvidesMethodTargetVisitor<Object, InjectionPoint> {
    private static final Logger logger = LoggerFactory.getLogger(InjectionPointExtractor.class);
    private final Predicate<TypeLiteral<?>> filter;

    public InjectionPointExtractor(Predicate<TypeLiteral<?>> filter) {
        this.filter = filter;
    }

    public InjectionPoint visit(UntargettedBinding<?> untargettedBinding) {
        return this.getInjectionPointForKey(untargettedBinding.getKey());
    }

    public InjectionPoint visit(LinkedKeyBinding<?> linkedKeyBinding) {
        return this.getInjectionPointForKey(linkedKeyBinding.getLinkedKey());
    }

    public InjectionPoint visit(ProviderKeyBinding<?> providerKeyBinding) {
        return this.getInjectionPointForKey(providerKeyBinding.getProviderKey());
    }

    public InjectionPoint visit(ProvidesMethodBinding<?> providesMethodBinding) {
        TypeLiteral type = TypeLiteral.get(providesMethodBinding.getEnclosingInstance().getClass());
        if (this.filter.test(type)) {
            try {
                return InjectionPoint.forMethod((Method)providesMethodBinding.getMethod(), (TypeLiteral)type);
            }
            catch (ConfigurationException e) {
                logger.info("Skipping key {}: {}", providesMethodBinding, (Object)e.getMessage());
                return null;
            }
        }
        return null;
    }

    private InjectionPoint getInjectionPointForKey(Key<?> key) {
        if (this.filter.test(key.getTypeLiteral())) {
            try {
                return InjectionPoint.forConstructorOf((TypeLiteral)key.getTypeLiteral());
            }
            catch (ConfigurationException e) {
                logger.info("Skipping key {}: {}", key, (Object)e.getMessage());
                return null;
            }
        }
        return null;
    }
}

