/*
 * Decompiled with CFR 0.152.
 */
package io.pleo.prop.guice.internal;

import com.google.common.base.Strings;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.PrivateElements;
import com.google.inject.spi.ProviderLookup;
import io.pleo.prop.core.Default;
import io.pleo.prop.core.Prop;
import io.pleo.prop.core.internal.ParserFactory;
import io.pleo.prop.core.internal.PropFactory;
import io.pleo.prop.guice.internal.FailedToCreatePropException;
import io.pleo.prop.guice.internal.InjectionPointExtractor;
import io.pleo.prop.guice.internal.PropResult;
import io.pleo.prop.guice.internal.RequiredNamedAnnotationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class PropMappingVisitor
extends DefaultElementVisitor<Map<Key<Prop<?>>, PropResult>> {
    private final InjectionPointExtractor injectionPointExtractor;
    private final PropFactory propFactory;
    private final ParserFactory parserFactory;

    public PropMappingVisitor(Predicate<TypeLiteral<?>> filter, PropFactory propFactory, ParserFactory parserFactory) {
        this.injectionPointExtractor = new InjectionPointExtractor(filter);
        this.propFactory = propFactory;
        this.parserFactory = parserFactory;
    }

    public Map<Key<Prop<?>>, PropResult> visit(Iterable<? extends Element> elements) {
        HashMap mappings = new HashMap();
        for (Element element : elements) {
            Map visitResult = (Map)element.acceptVisitor((ElementVisitor)this);
            if (visitResult == null) continue;
            mappings.putAll(visitResult);
        }
        return mappings;
    }

    public Map<Key<Prop<?>>, PropResult> visit(PrivateElements privateElements) {
        return this.visit(privateElements.getElements());
    }

    public <T> Map<Key<Prop<?>>, PropResult> visit(Binding<T> binding) {
        return this.extractProps((InjectionPoint)binding.acceptTargetVisitor((BindingTargetVisitor)this.injectionPointExtractor));
    }

    public <T> Map<Key<Prop<?>>, PropResult> visit(ProviderLookup<T> providerLookup) {
        return this.extractProps(providerLookup.getDependency().getInjectionPoint());
    }

    private Map<Key<Prop<?>>, PropResult> extractProps(InjectionPoint injectionPoint) {
        if (injectionPoint == null) {
            return new HashMap();
        }
        HashMap extractedProps = new HashMap();
        Member injectionPointMember = injectionPoint.getMember();
        if (injectionPointMember instanceof Executable) {
            List<Parameter> parameters = Arrays.asList(((Executable)injectionPointMember).getParameters());
            for (Dependency dependency : injectionPoint.getDependencies()) {
                PropResult result;
                Key key = dependency.getKey();
                if (!key.getTypeLiteral().getRawType().equals(Prop.class) || !(key.getTypeLiteral().getType() instanceof ParameterizedType)) continue;
                Parameter parameter = parameters.get(dependency.getParameterIndex());
                try {
                    result = new PropResult(this.parameterToProp(parameter, key));
                }
                catch (RuntimeException ex) {
                    result = new PropResult(ex);
                }
                extractedProps.put(dependency.getKey(), result);
            }
        }
        return extractedProps;
    }

    private Prop<?> parameterToProp(Parameter parameter, Key key) {
        String propertyName = PropMappingVisitor.getNamedAnnotationValue(Arrays.asList(parameter.getAnnotations()), key);
        Type type = ((ParameterizedType)parameter.getParameterizedType()).getActualTypeArguments()[0];
        Function parser = this.parserFactory.createParserForType(type);
        try {
            Object defaultValue = Optional.ofNullable(parameter.getAnnotation(Default.class)).map(Default::value).map(parser::apply).orElse(null);
            return this.propFactory.createProp(propertyName, parser, defaultValue);
        }
        catch (RuntimeException ex) {
            throw new FailedToCreatePropException(propertyName, ex);
        }
    }

    private static String getNamedAnnotationValue(List<Annotation> annotations, Key key) {
        Optional<String> propName = Optional.empty();
        for (Annotation annotation : annotations) {
            if (annotation instanceof javax.inject.Named) {
                propName = Optional.of(((javax.inject.Named)annotation).value());
                continue;
            }
            if (!(annotation instanceof Named)) continue;
            propName = Optional.of(((Named)annotation).value());
        }
        return propName.filter(name -> !Strings.isNullOrEmpty((String)name)).orElseThrow(() -> new RequiredNamedAnnotationException(key));
    }
}

