/*
 * Decompiled with CFR 0.152.
 */
package ratpack.util.internal;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class Paths2 {
    public static ByteSource asByteSource(Path path) {
        return new PathByteSource(path);
    }

    public static CharSource asCharSource(Path path, Charset charset) {
        return Paths2.asByteSource(path).asCharSource(charset);
    }

    public static String readText(Path path, Charset charset) throws IOException {
        return Paths2.asCharSource(path, charset).read();
    }

    private static final class PathByteSource
    extends ByteSource {
        private final Path path;

        private PathByteSource(Path path) {
            this.path = (Path)Preconditions.checkNotNull((Object)path);
        }

        public InputStream openStream() throws IOException {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }

        public long size() throws IOException {
            return Files.size(this.path);
        }

        public byte[] read() throws IOException {
            return Files.readAllBytes(this.path);
        }

        public String toString() {
            return "Paths2.asByteSource(" + this.path + ")";
        }
    }
}

