/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Map;
import ratpack.func.Action;
import ratpack.http.internal.DefaultHttpUrlBuilder;
import ratpack.util.MultiValueMap;

public interface HttpUrlBuilder {
    public static HttpUrlBuilder base(URI uri) {
        return new DefaultHttpUrlBuilder(uri);
    }

    public static HttpUrlBuilder http() {
        return new DefaultHttpUrlBuilder();
    }

    public static HttpUrlBuilder https() {
        return HttpUrlBuilder.http().secure();
    }

    public HttpUrlBuilder secure();

    public HttpUrlBuilder host(String var1);

    public HttpUrlBuilder port(int var1);

    public HttpUrlBuilder path(String var1);

    default public HttpUrlBuilder maybePath(String path) {
        if (path != null && !path.isEmpty()) {
            this.path(path);
        }
        return this;
    }

    public HttpUrlBuilder encodedPath(String var1);

    default public HttpUrlBuilder maybeEncodedPath(String path) {
        if (path != null && !path.isEmpty()) {
            this.encodedPath(path);
        }
        return this;
    }

    public HttpUrlBuilder segment(String var1, Object ... var2);

    public HttpUrlBuilder params(String ... var1);

    default public HttpUrlBuilder params(Action<? super ImmutableMultimap.Builder<String, Object>> params) throws Exception {
        return this.params((Multimap<String, ?>)((ImmutableMultimap.Builder)Action.with((Object)ImmutableMultimap.builder(), params)).build());
    }

    public HttpUrlBuilder params(Map<String, ?> var1);

    public HttpUrlBuilder params(Multimap<String, ?> var1);

    public HttpUrlBuilder params(MultiValueMap<String, ?> var1);

    public HttpUrlBuilder fragment(String var1);

    public URI build();
}

