/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import ratpack.exec.Result;

public class SingleElementSubscriber<T>
implements Subscriber<T> {
    private final Consumer<? super Result<T>> receiver;
    private Subscription subscription;
    private volatile T first;
    private AtomicBoolean fired = new AtomicBoolean();

    public static <T> Subscriber<T> to(Consumer<? super Result<T>> receiver) {
        return new SingleElementSubscriber<T>(receiver);
    }

    public SingleElementSubscriber(Consumer<? super Result<T>> receiver) {
        this.receiver = receiver;
    }

    public void onSubscribe(Subscription s) {
        if (this.subscription != null) {
            s.cancel();
            return;
        }
        this.subscription = s;
        this.subscription.request(Long.MAX_VALUE);
    }

    public void onNext(T o) {
        if (this.first == null) {
            this.first = o;
        } else {
            this.subscription.cancel();
            this.fire(Result.error(new IllegalStateException("Cannot convert stream of more than 1 item to a Promise")));
        }
    }

    private void fire(Result<T> result) {
        if (this.fired.compareAndSet(false, true)) {
            this.receiver.accept(result);
        }
    }

    public void onError(Throwable t) {
        this.fire(Result.error(t));
    }

    public void onComplete() {
        this.fire(Result.success(this.first));
    }
}

