/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session;

import java.util.Optional;
import java.util.Set;
import ratpack.exec.Operation;
import ratpack.exec.Promise;
import ratpack.session.JavaSessionSerializer;
import ratpack.session.SessionData;
import ratpack.session.SessionKey;
import ratpack.session.SessionSerializer;

public interface Session {
    public String getId();

    public Promise<SessionData> getData();

    default public Promise<Set<SessionKey<?>>> getKeys() {
        return this.getData().map(SessionData::getKeys);
    }

    default public <T> Promise<Optional<T>> get(SessionKey<T> key) {
        return this.getData().map(d -> d.get(key));
    }

    default public <T> Promise<Optional<T>> get(SessionKey<T> key, SessionSerializer serializer) {
        return this.getData().map(d -> d.get(key, serializer));
    }

    default public Promise<Optional<?>> get(String name) {
        return this.getData().map(d -> d.get(name));
    }

    default public Promise<Optional<?>> get(String name, SessionSerializer serializer) {
        return this.getData().map(d -> d.get(name, serializer));
    }

    default public <T> Promise<Optional<T>> get(Class<T> type) {
        return this.getData().map(d -> d.get(type));
    }

    default public <T> Promise<Optional<T>> get(Class<T> type, SessionSerializer serializer) {
        return this.getData().map(d -> d.get(type, serializer));
    }

    default public <T> Promise<T> require(SessionKey<T> key) {
        return this.getData().map(d -> d.require(key));
    }

    default public <T> Promise<T> require(SessionKey<T> key, SessionSerializer serializer) {
        return this.getData().map(d -> d.require(key, serializer));
    }

    default public <T> Promise<T> require(Class<T> type) {
        return this.getData().map(d -> d.require(type));
    }

    default public <T> Promise<T> require(Class<T> type, SessionSerializer serializer) {
        return this.getData().map(d -> d.require(type, serializer));
    }

    default public Promise<?> require(String name) {
        return this.getData().map(d -> d.require(name));
    }

    default public Promise<?> require(String name, SessionSerializer serializer) {
        return this.getData().map(d -> d.require(name, serializer));
    }

    default public <T> Operation set(SessionKey<T> key, T value) {
        return this.getData().operation(d -> d.set(key, value));
    }

    default public <T> Operation set(SessionKey<T> key, T value, SessionSerializer serializer) {
        return this.getData().operation(d -> d.set(key, value, serializer));
    }

    default public <T> Operation set(Class<T> type, T value) {
        return this.getData().operation(d -> d.set(type, value));
    }

    default public <T> Operation set(Class<T> type, T value, SessionSerializer serializer) {
        return this.getData().operation(d -> d.set(type, value, serializer));
    }

    default public <T> Operation set(String name, T value) {
        return this.getData().operation(d -> d.set(name, value));
    }

    default public <T> Operation set(String name, T value, SessionSerializer serializer) {
        return this.getData().operation(d -> d.set(name, value, serializer));
    }

    default public <T> Operation set(T value) {
        return this.getData().operation(d -> d.set(value));
    }

    default public <T> Operation set(T value, SessionSerializer serializer) {
        return this.getData().operation(d -> d.set(value, serializer));
    }

    default public Operation remove(SessionKey<?> key) {
        return this.getData().operation(d -> d.remove(key));
    }

    default public Operation remove(Class<?> type) {
        return this.getData().operation(d -> d.remove(type));
    }

    default public Operation remove(String name) {
        return this.getData().operation(d -> d.remove(name));
    }

    default public Operation clear() {
        return this.getData().operation(SessionData::clear);
    }

    public boolean isDirty();

    public Operation save();

    public Operation terminate();

    public JavaSessionSerializer getJavaSerializer();

    public SessionSerializer getDefaultSerializer();
}

