/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.internal;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import ratpack.exec.Operation;
import ratpack.exec.Promise;
import ratpack.http.Response;
import ratpack.session.JavaSessionSerializer;
import ratpack.session.Session;
import ratpack.session.SessionData;
import ratpack.session.SessionId;
import ratpack.session.SessionKey;
import ratpack.session.SessionSerializer;
import ratpack.session.SessionStore;
import ratpack.util.Exceptions;
import ratpack.util.Types;

public class DefaultSession
implements Session {
    private final Map<SessionKey<?>, byte[]> entries = Maps.newHashMap();
    private final SessionId sessionId;
    private final ByteBufAllocator bufferAllocator;
    private final SessionStore storeAdapter;
    private final Response response;
    private final SessionSerializer defaultSerializer;
    private final JavaSessionSerializer javaSerializer;
    private State state = State.NOT_LOADED;
    private boolean callbackAdded;
    private final SessionData data = new Data();

    public DefaultSession(SessionId sessionId, ByteBufAllocator bufferAllocator, SessionStore storeAdapter, Response response, SessionSerializer defaultSerializer, JavaSessionSerializer javaSerializer) {
        this.sessionId = sessionId;
        this.bufferAllocator = bufferAllocator;
        this.storeAdapter = storeAdapter;
        this.response = response;
        this.defaultSerializer = defaultSerializer;
        this.javaSerializer = javaSerializer;
    }

    @Override
    public String getId() {
        return this.sessionId.getValue().toString();
    }

    @Override
    public Promise<SessionData> getData() {
        if (this.state == State.NOT_LOADED) {
            return this.storeAdapter.load(this.sessionId.getValue()).map(bytes -> {
                this.state = State.CLEAN;
                try {
                    this.hydrate((ByteBuf)bytes);
                }
                finally {
                    bytes.release();
                }
                return this.data;
            });
        }
        return Promise.value((Object)this.data);
    }

    private void hydrate(ByteBuf bytes) {
        if (bytes.readableBytes() > 0) {
            try {
                SerializedForm deserialized = this.defaultSerializer.deserialize(SerializedForm.class, (InputStream)new ByteBufInputStream(bytes));
                this.entries.clear();
                this.entries.putAll(deserialized.entries);
            }
            catch (Exception e) {
                throw Exceptions.uncheck((Throwable)e);
            }
        }
    }

    @Override
    public JavaSessionSerializer getJavaSerializer() {
        return this.javaSerializer;
    }

    @Override
    public SessionSerializer getDefaultSerializer() {
        return this.defaultSerializer;
    }

    @Override
    public boolean isDirty() {
        return this.state == State.DIRTY;
    }

    private ByteBuf serialize() {
        SerializedForm serializable = new SerializedForm((Map<SessionKey<?>, byte[]>)ImmutableMap.copyOf(this.entries));
        ByteBuf buffer = this.bufferAllocator.buffer();
        ByteBufOutputStream outputStream = new ByteBufOutputStream(buffer);
        try {
            this.defaultSerializer.serialize(SerializedForm.class, serializable, (OutputStream)outputStream);
            outputStream.close();
            return buffer;
        }
        catch (Throwable e) {
            buffer.release();
            throw Exceptions.uncheck((Throwable)e);
        }
    }

    @Override
    public Operation save() {
        if (this.state == State.NOT_LOADED) {
            return Operation.noop();
        }
        return this.storeAdapter.store(this.sessionId.getValue(), this.serialize()).next(() -> {
            this.state = State.CLEAN;
        });
    }

    @Override
    public Operation terminate() {
        return this.storeAdapter.remove(this.sessionId.getValue()).next(() -> {
            this.sessionId.terminate();
            this.entries.clear();
            this.state = State.NOT_LOADED;
        });
    }

    private void markDirty() {
        this.state = State.DIRTY;
        if (!this.callbackAdded) {
            this.callbackAdded = true;
            this.response.beforeSend(responseMetaData -> {
                this.callbackAdded = false;
                if (this.state == State.DIRTY) {
                    this.save().then();
                }
            });
        }
    }

    private class Data
    implements SessionData {
        private Data() {
        }

        @Override
        public <T> Optional<T> get(SessionKey<T> key, SessionSerializer serializer) {
            String name = key.getName();
            if (key.getType() == null && (key = (SessionKey)Types.cast(this.findKey(name))) == null) {
                return Optional.empty();
            }
            byte[] bytes = (byte[])DefaultSession.this.entries.get(key);
            if (bytes == null) {
                return Optional.empty();
            }
            try {
                Object deserialized = serializer.deserialize(key.getType(), new ByteArrayInputStream(bytes));
                return Optional.of(deserialized);
            }
            catch (IOException e) {
                throw Exceptions.uncheck((Throwable)e);
            }
        }

        private SessionKey<?> findKey(String name) {
            ImmutableList entries = FluentIterable.from(DefaultSession.this.entries.entrySet()).filter(e -> Objects.equals(((SessionKey)e.getKey()).getName(), name)).toList();
            if (entries.isEmpty()) {
                return null;
            }
            if (entries.size() == 1) {
                return (SessionKey)((Map.Entry)entries.get(0)).getKey();
            }
            throw new IllegalArgumentException("Found more than one session entry with name '" + name + "': " + Iterables.transform((Iterable)entries, Map.Entry::getKey));
        }

        @Override
        public <T> void set(SessionKey<T> key, T value, SessionSerializer serializer) {
            Objects.requireNonNull(key, "session key cannot be null");
            Objects.requireNonNull(value, "session value for key " + key.getName() + " cannot be null");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                serializer.serialize(key.getType(), value, out);
            }
            catch (IOException e) {
                throw Exceptions.uncheck((Throwable)e);
            }
            DefaultSession.this.entries.put(key, out.toByteArray());
            DefaultSession.this.markDirty();
        }

        @Override
        public Set<SessionKey<?>> getKeys() {
            return DefaultSession.this.entries.keySet();
        }

        @Override
        public SessionSerializer getDefaultSerializer() {
            return DefaultSession.this.defaultSerializer;
        }

        @Override
        public void remove(SessionKey<?> key) {
            if (key.getType() == null && (key = this.findKey(key.getName())) == null) {
                return;
            }
            DefaultSession.this.entries.remove(key);
            DefaultSession.this.markDirty();
        }

        @Override
        public void clear() {
            DefaultSession.this.entries.clear();
            DefaultSession.this.markDirty();
        }

        @Override
        public Session getSession() {
            return DefaultSession.this;
        }
    }

    private static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Map<SessionKey<?>, byte[]> entries;

        public SerializedForm(Map<SessionKey<?>, byte[]> entries) {
            this.entries = entries;
        }
    }

    private static enum State {
        NOT_LOADED,
        CLEAN,
        DIRTY;

    }
}

