/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.BaseRealm;
import io.realm.RealmObject;
import io.realm.VersionId;
import io.realm.internal.InternalConfiguration;
import io.realm.internal.Observable;
import io.realm.internal.RealmLog;
import io.realm.internal.RealmReference;
import io.realm.internal.RealmResultsImpl;
import io.realm.internal.RealmState;
import io.realm.internal.RealmStateHolder;
import io.realm.internal.Thawable;
import io.realm.internal.interop.RealmInterop;
import io.realm.internal.schema.RealmSchemaImpl;
import io.realm.notifications.internal.Callback;
import io.realm.notifications.internal.Cancellable;
import io.realm.schema.RealmSchema;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000 62\u00020\u00012\u00020\u0002:\u00016B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\r\u0010\u0010\u001a\u00020\u0011H\u0010\u00a2\u0006\u0002\b\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J9\u0010\u0019\u001a\u00020\u001a\"\b\b\u0000\u0010\u001b*\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001b0\u001e0 H\u0010\u00a2\u0006\u0002\b!J1\u0010\"\u001a\u00020\u001a\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u0006\u0010#\u001a\u0002H\u001b2\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u001b0 H\u0010\u00a2\u0006\u0004\b$\u0010%J9\u0010&\u001a\b\u0012\u0004\u0012\u0002H(0'\"\u0004\b\u0000\u0010\u001b\"\u0004\b\u0001\u0010(2\u0018\u0010)\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H(0+0*H\u0010\u00a2\u0006\u0002\b,J9\u0010-\u001a\u00020\u001a\"\b\b\u0000\u0010\u001b*\u00020\u001c2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H\u001b0/2\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001b0/0 H\u0010\u00a2\u0006\u0002\b0J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\u0014H\u0016J\b\u00104\u001a\u000205H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00067"}, d2={"Lio/realm/internal/BaseRealmImpl;", "Lio/realm/BaseRealm;", "Lio/realm/internal/RealmStateHolder;", "configuration", "Lio/realm/internal/InternalConfiguration;", "(Lio/realm/internal/InternalConfiguration;)V", "getConfiguration", "()Lio/realm/internal/InternalConfiguration;", "log", "Lio/realm/internal/RealmLog;", "getLog$io_realm_kotlin_library", "()Lio/realm/internal/RealmLog;", "realmReference", "Lio/realm/internal/RealmReference;", "getRealmReference$io_realm_kotlin_library", "()Lio/realm/internal/RealmReference;", "close", "", "close$io_realm_kotlin_library", "getNumberOfActiveVersions", "", "isClosed", "", "realmState", "Lio/realm/internal/RealmState;", "registerListChangeListener", "Lio/realm/notifications/internal/Cancellable;", "T", "Lio/realm/RealmObject;", "list", "", "callback", "Lio/realm/notifications/internal/Callback;", "registerListChangeListener$io_realm_kotlin_library", "registerObjectChangeListener", "obj", "registerObjectChangeListener$io_realm_kotlin_library", "(Lio/realm/RealmObject;Lio/realm/notifications/internal/Callback;)Lio/realm/notifications/internal/Cancellable;", "registerObserver", "Lkotlinx/coroutines/flow/Flow;", "C", "t", "Lio/realm/internal/Thawable;", "Lio/realm/internal/Observable;", "registerObserver$io_realm_kotlin_library", "registerResultsChangeListener", "results", "Lio/realm/internal/RealmResultsImpl;", "registerResultsChangeListener$io_realm_kotlin_library", "schema", "Lio/realm/schema/RealmSchema;", "schemaVersion", "toString", "", "Companion", "io.realm.kotlin.library"})
public abstract class BaseRealmImpl
implements BaseRealm,
RealmStateHolder {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalConfiguration configuration;
    @NotNull
    private final RealmLog log;
    @Deprecated
    @NotNull
    private static final String OBSERVABLE_NOT_SUPPORTED_MESSAGE = "Observing changes are not supported by this Realm.";

    public BaseRealmImpl(@NotNull InternalConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        this.log = new RealmLog(null, this.configuration.getLog(), 1, null);
        this.log.info(Intrinsics.stringPlus((String)"Realm opened: ", (Object)this.configuration.getPath()), new Object[0]);
    }

    @Override
    @NotNull
    public final InternalConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public abstract RealmReference getRealmReference$io_realm_kotlin_library();

    @Override
    @NotNull
    public RealmState realmState() {
        return this.getRealmReference$io_realm_kotlin_library();
    }

    @Override
    public boolean isClosed() {
        return RealmStateHolder.DefaultImpls.isClosed(this);
    }

    @NotNull
    public final RealmLog getLog$io_realm_kotlin_library() {
        return this.log;
    }

    @Override
    @NotNull
    public RealmSchema schema() {
        return RealmSchemaImpl.Companion.fromRealm(this.getRealmReference$io_realm_kotlin_library().getDbPointer());
    }

    @Override
    public long schemaVersion() {
        return RealmInterop.INSTANCE.realm_get_schema_version(this.getRealmReference$io_realm_kotlin_library().getDbPointer());
    }

    @NotNull
    public <T, C> Flow<C> registerObserver$io_realm_kotlin_library(@NotNull Thawable<Observable<T, C>> t) {
        Intrinsics.checkNotNullParameter(t, (String)"t");
        throw new UnsupportedOperationException(OBSERVABLE_NOT_SUPPORTED_MESSAGE);
    }

    @NotNull
    public <T extends RealmObject> Cancellable registerResultsChangeListener$io_realm_kotlin_library(@NotNull RealmResultsImpl<T> results, @NotNull Callback<RealmResultsImpl<T>> callback) {
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        throw new NotImplementedError(OBSERVABLE_NOT_SUPPORTED_MESSAGE);
    }

    @NotNull
    public <T extends RealmObject> Cancellable registerListChangeListener$io_realm_kotlin_library(@NotNull List<? extends T> list, @NotNull Callback<List<T>> callback) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        throw new NotImplementedError(OBSERVABLE_NOT_SUPPORTED_MESSAGE);
    }

    @NotNull
    public <T extends RealmObject> Cancellable registerObjectChangeListener$io_realm_kotlin_library(@NotNull T obj, @NotNull Callback<T> callback) {
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        throw new NotImplementedError(OBSERVABLE_NOT_SUPPORTED_MESSAGE);
    }

    @Override
    public long getNumberOfActiveVersions() {
        RealmReference reference = this.getRealmReference$io_realm_kotlin_library();
        reference.checkClosed();
        return RealmInterop.INSTANCE.realm_get_num_versions(reference.getDbPointer());
    }

    public void close$io_realm_kotlin_library() {
        this.log.info("Realm closed: " + this + ' ' + this.configuration.getPath(), new Object[0]);
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + '[' + this.configuration.getPath() + "}]";
    }

    @Override
    @NotNull
    public VersionId version() {
        return RealmStateHolder.DefaultImpls.version(this);
    }

    @Override
    public boolean isFrozen() {
        return RealmStateHolder.DefaultImpls.isFrozen(this);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/realm/internal/BaseRealmImpl$Companion;", "", "()V", "OBSERVABLE_NOT_SUPPORTED_MESSAGE", "", "io.realm.kotlin.library"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

