/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.Deleteable;
import io.realm.MutableRealm;
import io.realm.RealmList;
import io.realm.RealmObject;
import io.realm.RealmObjectKt;
import io.realm.internal.Mediator;
import io.realm.internal.RealmObjectCompanion;
import io.realm.internal.RealmObjectInternal;
import io.realm.internal.RealmObjectUtilKt;
import io.realm.internal.RealmReference;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmCoreAddressSpaceExhaustedException;
import io.realm.internal.interop.RealmCoreCallbackException;
import io.realm.internal.interop.RealmCoreColumnAlreadyExistsException;
import io.realm.internal.interop.RealmCoreColumnNotFoundException;
import io.realm.internal.interop.RealmCoreCrossTableLinkTargetException;
import io.realm.internal.interop.RealmCoreDeleteOpenRealmException;
import io.realm.internal.interop.RealmCoreDuplicatePrimaryKeyValueException;
import io.realm.internal.interop.RealmCoreException;
import io.realm.internal.interop.RealmCoreFileAccessErrorException;
import io.realm.internal.interop.RealmCoreFilePermissionDeniedException;
import io.realm.internal.interop.RealmCoreIndexOutOfBoundsException;
import io.realm.internal.interop.RealmCoreInvalidArgumentException;
import io.realm.internal.interop.RealmCoreInvalidPathErrorException;
import io.realm.internal.interop.RealmCoreInvalidPropertyException;
import io.realm.internal.interop.RealmCoreInvalidQueryException;
import io.realm.internal.interop.RealmCoreInvalidQueryStringException;
import io.realm.internal.interop.RealmCoreInvalidatedObjectException;
import io.realm.internal.interop.RealmCoreKeyAlreadyUsedException;
import io.realm.internal.interop.RealmCoreKeyNotFoundException;
import io.realm.internal.interop.RealmCoreLogicException;
import io.realm.internal.interop.RealmCoreMaximumFileSizeExceededException;
import io.realm.internal.interop.RealmCoreMissingPrimaryKeyException;
import io.realm.internal.interop.RealmCoreMissingPropertyValueException;
import io.realm.internal.interop.RealmCoreModifyPrimaryKeyException;
import io.realm.internal.interop.RealmCoreMultipleSyncAgentsException;
import io.realm.internal.interop.RealmCoreNoSuchObjectException;
import io.realm.internal.interop.RealmCoreNoSuchTableException;
import io.realm.internal.interop.RealmCoreNoneException;
import io.realm.internal.interop.RealmCoreNotClonableException;
import io.realm.internal.interop.RealmCoreNotInATransactionException;
import io.realm.internal.interop.RealmCoreOtherException;
import io.realm.internal.interop.RealmCoreOutOfDiskSpaceException;
import io.realm.internal.interop.RealmCoreOutOfMemoryException;
import io.realm.internal.interop.RealmCorePropertyNotNullableException;
import io.realm.internal.interop.RealmCorePropertyTypeMismatchException;
import io.realm.internal.interop.RealmCoreReadOnlyPropertyException;
import io.realm.internal.interop.RealmCoreSerializationErrorException;
import io.realm.internal.interop.RealmCoreUnexpectedPrimaryKeyException;
import io.realm.internal.interop.RealmCoreUnknownException;
import io.realm.internal.interop.RealmCoreUnsupportedFileFormatVersionException;
import io.realm.internal.interop.RealmCoreWrongPrimaryKeyTypeException;
import io.realm.internal.interop.RealmCoreWrongThreadException;
import io.realm.internal.interop.RealmInterop;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0013\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u0080\b\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001aK\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u0002H\t2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0002\u0010\u0013\u001a5\u0010\u0014\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\t0\u0017H\u0000\u00a2\u0006\u0002\u0010\u0018\u001aG\u0010\u0014\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\t0\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\u0010\u001b\u001a=\u0010\u0014\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\t0\u00172\u0006\u0010\u001c\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\u0010\u001d\u001aO\u0010\u0014\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\t0\u00172\u0006\u0010\u001c\u001a\u00020\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\u0010\u001e\u001a\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"H\u0000\u001am\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0$\"\b\b\u0000\u0010\t*\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u00072\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u0002H\t\u0012\u0006\u0012\u0004\u0018\u00010\u001a0'2\u0006\u0010(\u001a\u0002H\t2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030$H\u0002\u00a2\u0006\u0002\u0010*\u00a8\u0006+"}, d2={"REPLACED_BY_IR", "", "message", "", "checkRealmClosed", "", "realm", "Lio/realm/internal/RealmReference;", "copyToRealm", "T", "mediator", "Lio/realm/internal/Mediator;", "realmReference", "element", "updatePolicy", "Lio/realm/MutableRealm$UpdatePolicy;", "cache", "", "Lio/realm/internal/RealmObjectInternal;", "(Lio/realm/internal/Mediator;Lio/realm/internal/RealmReference;Ljava/lang/Object;Lio/realm/MutableRealm$UpdatePolicy;Ljava/util/Map;)Ljava/lang/Object;", "create", "Lio/realm/RealmObject;", "type", "Lkotlin/reflect/KClass;", "(Lio/realm/internal/Mediator;Lio/realm/internal/RealmReference;Lkotlin/reflect/KClass;)Lio/realm/RealmObject;", "primaryKey", "", "(Lio/realm/internal/Mediator;Lio/realm/internal/RealmReference;Lkotlin/reflect/KClass;Ljava/lang/Object;Lio/realm/MutableRealm$UpdatePolicy;)Lio/realm/RealmObject;", "className", "(Lio/realm/internal/Mediator;Lio/realm/internal/RealmReference;Lkotlin/reflect/KClass;Ljava/lang/String;)Lio/realm/RealmObject;", "(Lio/realm/internal/Mediator;Lio/realm/internal/RealmReference;Lkotlin/reflect/KClass;Ljava/lang/String;Ljava/lang/Object;Lio/realm/MutableRealm$UpdatePolicy;)Lio/realm/RealmObject;", "genericRealmCoreExceptionHandler", "", "cause", "Lio/realm/internal/interop/RealmCoreException;", "processListMember", "Lio/realm/RealmList;", "realmPointer", "member", "Lkotlin/reflect/KMutableProperty1;", "target", "sourceObject", "(Lio/realm/internal/Mediator;Lio/realm/internal/RealmReference;Ljava/util/Map;Lkotlin/reflect/KMutableProperty1;Lio/realm/RealmObject;Lio/realm/RealmList;)Lio/realm/RealmList;", "io.realm.kotlin.library"})
public final class RealmUtilsKt {
    @NotNull
    public static final Void REPLACED_BY_IR(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean $i$f$REPLACED_BY_IR = false;
        throw new AssertionError((Object)message);
    }

    public static /* synthetic */ Void REPLACED_BY_IR$default(String message, int n, Object object) {
        if ((n & 1) != 0) {
            message = "This code should have been replaced by the Realm Compiler Plugin. Has the `realm-kotlin` Gradle plugin been applied to the project?";
        }
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean $i$f$REPLACED_BY_IR = false;
        throw new AssertionError((Object)message);
    }

    public static final void checkRealmClosed(@NotNull RealmReference realm) {
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        if (RealmInterop.INSTANCE.realm_is_closed(realm.getDbPointer())) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)realm.getOwner().getConfiguration().getPath()));
        }
    }

    @NotNull
    public static final <T extends RealmObject> T create(@NotNull Mediator mediator, @NotNull RealmReference realm, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return RealmUtilsKt.create(mediator, realm, type, io.realm.internal.platform.RealmObjectKt.realmObjectCompanionOrThrow(type).get$realm$className());
    }

    @NotNull
    public static final <T extends RealmObject> T create(@NotNull Mediator mediator, @NotNull RealmReference realm, @NotNull KClass<T> type, @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        try {
            long key;
            long l;
            RealmObjectInternal managedModel = mediator.createInstanceOf(type);
            long it = l = (key = realm.getSchemaMetadata().getOrThrow(className).getClassKey-gequ3zM());
            boolean bl = false;
            return RealmObjectUtilKt.manage(managedModel, realm, mediator, type, RealmInterop.INSTANCE.realm_object_create-DimupYc(realm.getDbPointer(), key));
        }
        catch (RealmCoreException e) {
            throw RealmUtilsKt.genericRealmCoreExceptionHandler("Failed to create object of type '" + className + '\'', e);
        }
    }

    @NotNull
    public static final <T extends RealmObject> T create(@NotNull Mediator mediator, @NotNull RealmReference realm, @NotNull KClass<T> type, @Nullable Object primaryKey, @NotNull MutableRealm.UpdatePolicy updatePolicy) {
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)updatePolicy), (String)"updatePolicy");
        return RealmUtilsKt.create(mediator, realm, type, io.realm.internal.platform.RealmObjectKt.realmObjectCompanionOrThrow(type).get$realm$className(), primaryKey, updatePolicy);
    }

    @NotNull
    public static final <T extends RealmObject> T create(@NotNull Mediator mediator, @NotNull RealmReference realm, @NotNull KClass<T> type, @NotNull String className, @Nullable Object primaryKey, @NotNull MutableRealm.UpdatePolicy updatePolicy) {
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)((Object)updatePolicy), (String)"updatePolicy");
        try {
            NativePointer nativePointer;
            long key;
            long l;
            long it = l = (key = realm.getSchemaMetadata().getOrThrow(className).getClassKey-gequ3zM());
            boolean bl = false;
            RealmObjectInternal managedModel = mediator.createInstanceOf(type);
            switch (WhenMappings.$EnumSwitchMapping$0[updatePolicy.ordinal()]) {
                case 1: {
                    nativePointer = RealmInterop.INSTANCE.realm_object_create_with_primary_key-CEpJScw(realm.getDbPointer(), key, primaryKey);
                    break;
                }
                case 2: {
                    nativePointer = RealmInterop.INSTANCE.realm_object_get_or_create_with_primary_key-CEpJScw(realm.getDbPointer(), key, primaryKey);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            NativePointer nativeObject = nativePointer;
            return RealmObjectUtilKt.manage(managedModel, realm, mediator, type, nativeObject);
        }
        catch (RealmCoreException e) {
            throw RealmUtilsKt.genericRealmCoreExceptionHandler("Failed to create object of type '" + className + '\'', e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final <T> T copyToRealm(@NotNull Mediator mediator, @NotNull RealmReference realmReference2, T element, @NotNull MutableRealm.UpdatePolicy updatePolicy, @NotNull Map<RealmObjectInternal, RealmObjectInternal> cache) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter((Object)realmReference2, (String)"realmReference");
        Intrinsics.checkNotNullParameter((Object)((Object)updatePolicy), (String)"updatePolicy");
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        if (element instanceof RealmObjectInternal) {
            if (!RealmObjectKt.isValid((RealmObject)element)) {
                throw new IllegalArgumentException("Cannot copy an invalid managed object to Realm.");
            }
            if (RealmObjectKt.isManaged((RealmObject)element)) {
                if (!Intrinsics.areEqual((Object)((RealmObjectInternal)element).get$realm$Owner(), (Object)realmReference2)) throw new IllegalArgumentException("Cannot set/copyToRealm an outdated object. User findLatest(object) to find the version of the object required in the given context.");
                object = element;
                return object;
            } else {
                RealmObjectInternal realmObjectInternal;
                KMutableProperty1<?, ?> primaryKeyMember;
                RealmObjectInternal instance = (RealmObjectInternal)element;
                RealmObjectCompanion companion = mediator.companionOf((KClass<? extends RealmObject>)Reflection.getOrCreateKotlinClass(instance.getClass()));
                List<KMutableProperty1<?, ?>> list = companion.get$realm$fields();
                if (list == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.reflect.KMutableProperty1<io.realm.internal.RealmObjectInternal, kotlin.Any?>>");
                }
                List<KMutableProperty1<?, ?>> members = list;
                KMutableProperty1<?, ?> kMutableProperty1 = primaryKeyMember = companion.get$realm$primaryKey();
                if (kMutableProperty1 == null) {
                    realmObjectInternal = null;
                } else {
                    KMutableProperty1<?, ?> primaryKey = kMutableProperty1;
                    boolean bl = false;
                    realmObjectInternal = (RealmObjectInternal)RealmUtilsKt.create(mediator, realmReference2, Reflection.getOrCreateKotlinClass(instance.getClass()), ((KProperty1)primaryKey).get((Object)instance), updatePolicy);
                }
                RealmObjectInternal realmObjectInternal2 = realmObjectInternal;
                RealmObjectInternal target = realmObjectInternal2 == null ? (RealmObjectInternal)RealmUtilsKt.create(mediator, realmReference2, Reflection.getOrCreateKotlinClass(instance.getClass())) : realmObjectInternal2;
                cache.put(instance, target);
                for (KMutableProperty1 kMutableProperty12 : members) {
                    RealmList<Object> it;
                    RealmList<Object> targetValue;
                    Deleteable deleteable;
                    if (Intrinsics.areEqual((Object)kMutableProperty12, primaryKeyMember)) continue;
                    RealmList<Object> sourceObject = kMutableProperty12.get((Object)instance);
                    boolean bl = false;
                    if (sourceObject instanceof RealmObjectInternal && !((RealmObjectInternal)((Object)sourceObject)).get$realm$IsManaged()) {
                        void $this$getOrPut$iv;
                        Map<RealmObjectInternal, RealmObjectInternal> map2 = cache;
                        RealmList<Object> key$iv = sourceObject;
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl2 = false;
                            RealmObjectInternal answer$iv = (RealmObjectInternal)((Object)RealmUtilsKt.copyToRealm(mediator, realmReference2, sourceObject, updatePolicy, cache));
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            deleteable = answer$iv;
                        } else {
                            deleteable = value$iv;
                        }
                    } else {
                        deleteable = sourceObject instanceof RealmList ? RealmUtilsKt.processListMember(mediator, realmReference2, cache, kMutableProperty12, (RealmObject)target, sourceObject) : sourceObject;
                    }
                    if ((targetValue = deleteable) == null) continue;
                    boolean bl3 = false;
                    kMutableProperty12.set((Object)target, it);
                }
                object = target;
            }
            return object;
        } else {
            object = element;
        }
        return object;
    }

    public static /* synthetic */ Object copyToRealm$default(Mediator mediator, RealmReference realmReference2, Object object, MutableRealm.UpdatePolicy updatePolicy, Map map2, int n, Object object2) {
        if ((n & 8) != 0) {
            updatePolicy = MutableRealm.UpdatePolicy.ERROR;
        }
        if ((n & 0x10) != 0) {
            map2 = new LinkedHashMap();
        }
        return RealmUtilsKt.copyToRealm(mediator, realmReference2, object, updatePolicy, map2);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T extends RealmObject> RealmList<Object> processListMember(Mediator mediator, RealmReference realmPointer, Map<RealmObjectInternal, RealmObjectInternal> cache, KMutableProperty1<T, Object> member, T target, RealmList<?> sourceObject) {
        Object object = member.get(target);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.realm.RealmList<kotlin.Any?>");
        }
        RealmList list = (RealmList)object;
        for (Object item : sourceObject) {
            if (item instanceof RealmObjectInternal && !((RealmObjectInternal)item).get$realm$IsManaged()) {
                Object object2;
                void $this$getOrPut$iv;
                Map<RealmObjectInternal, RealmObjectInternal> map2 = cache;
                Object key$iv = item;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    RealmObjectInternal answer$iv = (RealmObjectInternal)RealmUtilsKt.copyToRealm(mediator, realmPointer, item, MutableRealm.UpdatePolicy.ERROR, cache);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                RealmObjectInternal value = (RealmObjectInternal)object2;
                list.add(value);
                continue;
            }
            list.add(item);
        }
        return list;
    }

    @NotNull
    public static final Throwable genericRealmCoreExceptionHandler(@NotNull String message, @NotNull RealmCoreException cause) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)cause), (String)"cause");
        RealmCoreException realmCoreException = cause;
        if ((((((realmCoreException instanceof RealmCoreOutOfMemoryException ? true : realmCoreException instanceof RealmCoreUnsupportedFileFormatVersionException) ? true : realmCoreException instanceof RealmCoreInvalidPathErrorException) ? true : realmCoreException instanceof RealmCoreMultipleSyncAgentsException) ? true : realmCoreException instanceof RealmCoreAddressSpaceExhaustedException) ? true : realmCoreException instanceof RealmCoreMaximumFileSizeExceededException) ? true : realmCoreException instanceof RealmCoreOutOfDiskSpaceException) {
            throwable = new Error(message + ": RealmCoreException(" + cause.getMessage() + ')', cause);
        } else if (realmCoreException instanceof RealmCoreIndexOutOfBoundsException) {
            throwable = new IndexOutOfBoundsException(message + ": RealmCoreException(" + cause.getMessage() + ')');
        } else if ((((((((realmCoreException instanceof RealmCoreInvalidArgumentException ? true : realmCoreException instanceof RealmCoreInvalidQueryStringException) ? true : realmCoreException instanceof RealmCoreOtherException) ? true : realmCoreException instanceof RealmCoreInvalidQueryException) ? true : realmCoreException instanceof RealmCoreMissingPrimaryKeyException) ? true : realmCoreException instanceof RealmCoreUnexpectedPrimaryKeyException) ? true : realmCoreException instanceof RealmCoreWrongPrimaryKeyTypeException) ? true : realmCoreException instanceof RealmCoreModifyPrimaryKeyException) ? true : realmCoreException instanceof RealmCoreDuplicatePrimaryKeyValueException) {
            throwable = new IllegalArgumentException(message + ": RealmCoreException(" + cause.getMessage() + ')', cause);
        } else if ((((realmCoreException instanceof RealmCoreNotInATransactionException ? true : realmCoreException instanceof RealmCoreDeleteOpenRealmException) ? true : realmCoreException instanceof RealmCoreFileAccessErrorException) ? true : realmCoreException instanceof RealmCoreFilePermissionDeniedException) ? true : realmCoreException instanceof RealmCoreLogicException) {
            throwable = new IllegalStateException(message + ": RealmCoreException(" + cause.getMessage() + ')', cause);
        } else if ((((((((((((((((((realmCoreException instanceof RealmCoreNoneException ? true : realmCoreException instanceof RealmCoreUnknownException) ? true : realmCoreException instanceof RealmCoreNotClonableException) ? true : realmCoreException instanceof RealmCoreWrongThreadException) ? true : realmCoreException instanceof RealmCoreInvalidatedObjectException) ? true : realmCoreException instanceof RealmCoreInvalidPropertyException) ? true : realmCoreException instanceof RealmCoreMissingPropertyValueException) ? true : realmCoreException instanceof RealmCorePropertyTypeMismatchException) ? true : realmCoreException instanceof RealmCoreReadOnlyPropertyException) ? true : realmCoreException instanceof RealmCorePropertyNotNullableException) ? true : realmCoreException instanceof RealmCoreNoSuchTableException) ? true : realmCoreException instanceof RealmCoreNoSuchObjectException) ? true : realmCoreException instanceof RealmCoreCrossTableLinkTargetException) ? true : realmCoreException instanceof RealmCoreKeyNotFoundException) ? true : realmCoreException instanceof RealmCoreColumnNotFoundException) ? true : realmCoreException instanceof RealmCoreColumnAlreadyExistsException) ? true : realmCoreException instanceof RealmCoreKeyAlreadyUsedException) ? true : realmCoreException instanceof RealmCoreSerializationErrorException) ? true : realmCoreException instanceof RealmCoreCallbackException) {
            throwable = new RuntimeException(message + ": RealmCoreException(" + cause.getMessage() + ')', cause);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return throwable;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MutableRealm.UpdatePolicy.values().length];
            nArray[MutableRealm.UpdatePolicy.ERROR.ordinal()] = 1;
            nArray[MutableRealm.UpdatePolicy.ALL.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

