/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.dynamic;

import io.realm.Deleteable;
import io.realm.MutableRealm;
import io.realm.RealmObject;
import io.realm.RealmObjectKt;
import io.realm.dynamic.DynamicMutableRealm;
import io.realm.dynamic.DynamicMutableRealmObject;
import io.realm.internal.BaseRealmImpl;
import io.realm.internal.InternalConfiguration;
import io.realm.internal.InternalDeleteableKt;
import io.realm.internal.LiveRealmReference;
import io.realm.internal.RealmObjectInternal;
import io.realm.internal.RealmReference;
import io.realm.internal.RealmUtilsKt;
import io.realm.internal.WriteTransactionManager;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.query.ObjectQuery;
import io.realm.query.RealmQuery;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J;\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001b2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00102\u0016\u0010\u001d\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00120\u001e\"\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u001fR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Lio/realm/internal/dynamic/DynamicMutableRealmImpl;", "Lio/realm/internal/BaseRealmImpl;", "Lio/realm/dynamic/DynamicMutableRealm;", "Lio/realm/internal/WriteTransactionManager;", "configuration", "Lio/realm/internal/InternalConfiguration;", "dbPointer", "Lio/realm/internal/interop/NativePointer;", "(Lio/realm/internal/InternalConfiguration;Lio/realm/internal/interop/NativePointer;)V", "realmReference", "Lio/realm/internal/LiveRealmReference;", "getRealmReference", "()Lio/realm/internal/LiveRealmReference;", "createObject", "Lio/realm/dynamic/DynamicMutableRealmObject;", "type", "", "primaryKey", "", "delete", "", "deleteable", "Lio/realm/Deleteable;", "findLatest", "obj", "Lio/realm/RealmObject;", "query", "Lio/realm/query/RealmQuery;", "className", "args", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Lio/realm/query/RealmQuery;", "io.realm.kotlin.library"})
public class DynamicMutableRealmImpl
extends BaseRealmImpl
implements DynamicMutableRealm,
WriteTransactionManager {
    @NotNull
    private final LiveRealmReference realmReference;

    public DynamicMutableRealmImpl(@NotNull InternalConfiguration configuration, @NotNull NativePointer dbPointer) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)dbPointer, (String)"dbPointer");
        super(configuration);
        this.realmReference = new LiveRealmReference(this, dbPointer);
    }

    @Override
    @NotNull
    public LiveRealmReference getRealmReference() {
        return this.realmReference;
    }

    @Override
    @NotNull
    public RealmQuery<DynamicMutableRealmObject> query(@NotNull String className, @NotNull String query2, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ObjectQuery((RealmReference)this.getRealmReference(), this.getRealmReference().getSchemaMetadata().getOrThrow(className).getClassKey-gequ3zM(), Reflection.getOrCreateKotlinClass(DynamicMutableRealmObject.class), this.getConfiguration().getMediator(), null, query2, Arrays.copyOf(args, args.length), null);
    }

    @Override
    @NotNull
    public DynamicMutableRealmObject createObject(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return (DynamicMutableRealmObject)RealmUtilsKt.create(this.getConfiguration().getMediator(), this.getRealmReference(), Reflection.getOrCreateKotlinClass(DynamicMutableRealmObject.class), type);
    }

    @Override
    @NotNull
    public DynamicMutableRealmObject createObject(@NotNull String type, @Nullable Object primaryKey) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return (DynamicMutableRealmObject)RealmUtilsKt.create(this.getConfiguration().getMediator(), this.getRealmReference(), Reflection.getOrCreateKotlinClass(DynamicMutableRealmObject.class), type, primaryKey, MutableRealm.UpdatePolicy.ERROR);
    }

    @Override
    @Nullable
    public DynamicMutableRealmObject findLatest(@NotNull RealmObject obj) {
        DynamicMutableRealmObject dynamicMutableRealmObject;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (!RealmObjectKt.isValid(obj)) {
            dynamicMutableRealmObject = null;
        } else {
            if (!RealmObjectKt.isManaged(obj)) {
                throw new IllegalArgumentException("Cannot lookup unmanaged object");
            }
            dynamicMutableRealmObject = Intrinsics.areEqual((Object)((RealmObjectInternal)obj).get$realm$Owner(), (Object)this.getRealmReference()) ? (DynamicMutableRealmObject)obj : (DynamicMutableRealmObject)((Object)((RealmObjectInternal)obj).thaw(this.getRealmReference(), (KClass<? extends RealmObject>)Reflection.getOrCreateKotlinClass(DynamicMutableRealmObject.class)));
        }
        return dynamicMutableRealmObject;
    }

    @Override
    public void delete(@NotNull Deleteable deleteable) {
        Intrinsics.checkNotNullParameter((Object)deleteable, (String)"deleteable");
        InternalDeleteableKt.asInternalDeleteable(deleteable).delete();
    }

    @Override
    public void beginTransaction() {
        WriteTransactionManager.DefaultImpls.beginTransaction(this);
    }

    @Override
    public boolean isInTransaction() {
        return WriteTransactionManager.DefaultImpls.isInTransaction(this);
    }

    @Override
    public void commitTransaction() {
        WriteTransactionManager.DefaultImpls.commitTransaction(this);
    }

    @Override
    public void cancelWrite() {
        WriteTransactionManager.DefaultImpls.cancelWrite(this);
    }
}

