/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.VersionId;
import io.realm.internal.BaseRealmImpl;
import io.realm.internal.FrozenRealmReference;
import io.realm.internal.RealmReference;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmInterop;
import io.realm.internal.schema.CachedSchemaMetadata;
import io.realm.internal.schema.SchemaMetadata;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lio/realm/internal/LiveRealmReference;", "Lio/realm/internal/RealmReference;", "owner", "Lio/realm/internal/BaseRealmImpl;", "dbPointer", "Lio/realm/internal/interop/NativePointer;", "(Lio/realm/internal/BaseRealmImpl;Lio/realm/internal/interop/NativePointer;)V", "_schemaMetadata", "Lkotlinx/atomicfu/AtomicRef;", "Lio/realm/internal/schema/SchemaMetadata;", "getDbPointer", "()Lio/realm/internal/interop/NativePointer;", "getOwner", "()Lio/realm/internal/BaseRealmImpl;", "schemaMetadata", "getSchemaMetadata", "()Lio/realm/internal/schema/SchemaMetadata;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "refreshSchemaMetadata", "", "snapshot", "Lio/realm/internal/FrozenRealmReference;", "toString", "", "io.realm.kotlin.library"})
public final class LiveRealmReference
implements RealmReference {
    @NotNull
    private final BaseRealmImpl owner;
    @NotNull
    private final NativePointer dbPointer;
    @NotNull
    private final AtomicRef<SchemaMetadata> _schemaMetadata;

    public LiveRealmReference(@NotNull BaseRealmImpl owner, @NotNull NativePointer dbPointer) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)dbPointer, (String)"dbPointer");
        this.owner = owner;
        this.dbPointer = dbPointer;
        this._schemaMetadata = AtomicFU.atomic((Object)new CachedSchemaMetadata(this.getDbPointer()));
    }

    @Override
    @NotNull
    public BaseRealmImpl getOwner() {
        return this.owner;
    }

    @Override
    @NotNull
    public NativePointer getDbPointer() {
        return this.dbPointer;
    }

    @Override
    @NotNull
    public SchemaMetadata getSchemaMetadata() {
        return (SchemaMetadata)this._schemaMetadata.getValue();
    }

    @NotNull
    public final FrozenRealmReference snapshot(@NotNull BaseRealmImpl owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        return new FrozenRealmReference(owner, RealmInterop.INSTANCE.realm_freeze(this.getDbPointer()), this.getSchemaMetadata());
    }

    public final void refreshSchemaMetadata() {
        this._schemaMetadata.setValue((Object)new CachedSchemaMetadata(this.getDbPointer()));
    }

    @Override
    @NotNull
    public VersionId version() {
        return RealmReference.DefaultImpls.version(this);
    }

    @Override
    public boolean isFrozen() {
        return RealmReference.DefaultImpls.isFrozen(this);
    }

    @Override
    public boolean isClosed() {
        return RealmReference.DefaultImpls.isClosed(this);
    }

    @Override
    public void close() {
        RealmReference.DefaultImpls.close(this);
    }

    @Override
    public void checkClosed() {
        RealmReference.DefaultImpls.checkClosed(this);
    }

    @NotNull
    public final BaseRealmImpl component1() {
        return this.getOwner();
    }

    @NotNull
    public final NativePointer component2() {
        return this.getDbPointer();
    }

    @NotNull
    public final LiveRealmReference copy(@NotNull BaseRealmImpl owner, @NotNull NativePointer dbPointer) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)dbPointer, (String)"dbPointer");
        return new LiveRealmReference(owner, dbPointer);
    }

    public static /* synthetic */ LiveRealmReference copy$default(LiveRealmReference liveRealmReference, BaseRealmImpl baseRealmImpl, NativePointer nativePointer, int n, Object object) {
        if ((n & 1) != 0) {
            baseRealmImpl = liveRealmReference.getOwner();
        }
        if ((n & 2) != 0) {
            nativePointer = liveRealmReference.getDbPointer();
        }
        return liveRealmReference.copy(baseRealmImpl, nativePointer);
    }

    @NotNull
    public String toString() {
        return "LiveRealmReference(owner=" + this.getOwner() + ", dbPointer=" + this.getDbPointer() + ')';
    }

    public int hashCode() {
        int result = this.getOwner().hashCode();
        result = result * 31 + this.getDbPointer().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LiveRealmReference)) {
            return false;
        }
        LiveRealmReference liveRealmReference = (LiveRealmReference)other;
        if (!Intrinsics.areEqual((Object)this.getOwner(), (Object)liveRealmReference.getOwner())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getDbPointer(), (Object)liveRealmReference.getDbPointer());
    }
}

